<?php
declare(strict_types=1);
require_once __DIR__ . '/includes/header.php';

function validar_url(string $u): bool {
  return (bool) filter_var($u, FILTER_VALIDATE_URL);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $acao = $_POST['action'] ?? '';
  if (in_array($acao, ['create','update','delete','toggle'], true)) require_csrf();

  if ($acao === 'create') {
    $titulo  = trim((string)($_POST['title'] ?? ''));
    $url     = trim((string)($_POST['url'] ?? ''));
    $ativo   = isset($_POST['active']) ? 1 : 0;
    $notas   = trim((string)($_POST['notes'] ?? ''));

    if ($titulo === '' || $url === '') {
      flash('info', 'T&iacute;tulo e URL s&atilde;o obrigat&oacute;rios.');
      redirect('webview_pages.php');
    }
    if (!validar_url($url)) {
      flash('info', 'Informe uma URL v&aacute;lida (incluindo http/https).');
      redirect('webview_pages.php');
    }

    try {
      DB::exec(
        'INSERT INTO webview_pages (title,url,active,notes,created_at,updated_at) VALUES (?,?,?,?,?,?)',
        [$titulo,$url,$ativo,$notas,gmdate('c'),gmdate('c')]
      );
      flash('info','P&aacute;gina WebView criada');
    } catch (Throwable $e) {
      flash('info','N&atilde;o foi poss&iacute;vel criar a p&aacute;gina.');
    }
    redirect('webview_pages.php');
  }

  if ($acao === 'update') {
    $id      = (int)($_POST['id'] ?? 0);
    $titulo  = trim((string)($_POST['title'] ?? ''));
    $url     = trim((string)($_POST['url'] ?? ''));
    $ativo   = isset($_POST['active']) ? 1 : 0;
    $notas   = trim((string)($_POST['notes'] ?? ''));

    if ($id <= 0 || $titulo === '' || $url === '') {
      flash('info','Todos os campos s&atilde;o obrigat&oacute;rios.');
      redirect('webview_pages.php');
    }
    if (!validar_url($url)) {
      flash('info','URL inv&aacute;lida.');
      redirect('webview_pages.php');
    }

    try {
      DB::exec(
        'UPDATE webview_pages SET title=?, url=?, active=?, notes=?, updated_at=? WHERE id=?',
        [$titulo,$url,$ativo,$notas,gmdate('c'),$id]
      );
      flash('info','P&aacute;gina WebView atualizada');
    } catch (Throwable $e) {
      flash('info','N&atilde;o foi poss&iacute;vel atualizar a p&aacute;gina.');
    }
    redirect('webview_pages.php');
  }

  if ($acao === 'delete') {
    $id = (int)($_POST['id'] ?? 0);
    if ($id > 0) {
      DB::exec('DELETE FROM webview_pages WHERE id=?', [$id]);
      flash('info','P&aacute;gina WebView exclu&iacute;da');
    }
    redirect('webview_pages.php');
  }

  if ($acao === 'toggle') {
    $id = (int)($_POST['id'] ?? 0);
    if ($id > 0) {
      $row = DB::one('SELECT active FROM webview_pages WHERE id=?', [$id]);
      if ($row) {
        $novo = ((int)$row['active'] === 1) ? 0 : 1;
        DB::exec('UPDATE webview_pages SET active=?, updated_at=? WHERE id=?', [$novo, gmdate('c'), $id]);
      }
    }
    redirect('webview_pages.php');
  }
}

// editar modal
$editar = null;
if (isset($_GET['edit'])) {
  $eid = (int)$_GET['edit'];
  $editar = DB::one('SELECT * FROM webview_pages WHERE id=?', [$eid]);
}

$linhas = DB::all('SELECT * FROM webview_pages ORDER BY id DESC');
?>

<h1 class="text-2xl font-bold mb-4">P&aacute;ginas WebView</h1>

<div class="grid md:grid-cols-2 gap-6">
  <form method="post" class="surface p-4 rounded">
    <?= csrf_input(); ?>
    <input type="hidden" name="action" value="create">

    <label>T&iacute;tulo</label>
    <input name="title" required>

    <label class="mt-2">URL</label>
    <input name="url" placeholder="https://exemplo.com/pagina" required>

    <label class="mt-2">Notas (opcional)</label>
    <textarea name="notes" rows="3"></textarea>

    <div class="mt-2 flex items-center gap-2">
      <label class="cursor-pointer flex items-center gap-2">
        <input type="checkbox" name="active" checked> <span>Ativa</span>
      </label>
    </div>

    <div class="mt-3"><button class="btn">Adicionar P&aacute;gina WebView</button></div>
  </form>

  <div class="surface p-2 rounded">
    <table class="table">
      <thead><tr><th>ID</th><th>T&iacute;tulo</th><th>URL</th><th>Ativa</th><th></th></tr></thead>
      <tbody>
      <?php foreach ($linhas as $r): ?>
        <tr>
          <td><?php echo (int)$r['id']; ?></td>
          <td><?php echo h((string)$r['title']); ?></td>
          <td class="truncate max-w-[260px]" title="<?php echo h((string)$r['url']); ?>">
            <?php echo h((string)$r['url']); ?>
          </td>
          <td>
            <form method="post" style="display:inline">
              <?= csrf_input(); ?>
              <input type="hidden" name="action" value="toggle">
              <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>">
              <button class="btn-ghost" title="Alternar ativa">
                <?php echo ((int)$r['active']===1?'Sim':'N&atilde;o'); ?>
              </button>
            </form>
          </td>
          <td class="text-right">
            <a class="btn-ghost" href="webview_pages.php?edit=<?php echo (int)$r['id']; ?>">Editar</a>
            <form method="post" onsubmit="return confirm('Excluir p&aacute;gina?');" style="display:inline">
              <?= csrf_input(); ?>
              <input type="hidden" name="action" value="delete">
              <input type="hidden" name="id" value="<?php echo (int)$r['id']; ?>">
              <button class="btn-rose">Excluir</button>
            </form>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php if ($editar): ?>
<div class="modal-backdrop show" id="modalWvEdit">
  <div class="modal">
    <header>
      <div>Editar P&aacute;gina WebView #<?php echo (int)$editar['id']; ?></div>
      <a href="webview_pages.php" data-modal-close="modalWvEdit">×</a>
    </header>
    <div class="content">
      <form method="post" id="formWvEdit">
        <?= csrf_input(); ?>
        <input type="hidden" name="action" value="update">
        <input type="hidden" name="id" value="<?php echo (int)$editar['id']; ?>">

        <label>T&iacute;tulo</label>
        <input name="title" value="<?php echo h((string)$editar['title']); ?>" required>

        <label class="mt-2">URL</label>
        <input name="url" value="<?php echo h((string)$editar['url']); ?>" required>

        <label class="mt-2">Notas</label>
        <textarea name="notes" rows="3"><?php echo h((string)($editar['notes'] ?? '')); ?></textarea>

        <label class="mt-2 flex items-center gap-2">
          <input type="checkbox" name="active" <?php echo ((int)$editar['active']===1?'checked':''); ?>>
          <span>Ativa</span>
        </label>
      </form>
    </div>
    <footer>
      <a href="webview_pages.php" class="btn-ghost" data-modal-close="modalWvEdit">Cancelar</a>
      <button class="btn" onclick="document.getElementById('formWvEdit').submit()">Salvar Alterações</button>
    </footer>
  </div>
</div>
<?php endif; ?>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
