<?php
require_once __DIR__ . '/includes/config.php';
if (!empty($_SESSION['user_id'])) redirect('index.php');

$erro = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  require_csrf();
  $usuario = trim((string)($_POST['username'] ?? ''));
  $senha = (string)($_POST['password'] ?? '');
  
  if ($usuario === '' || $senha === '') {
    $erro = 'Por favor, informe o nome de usuário e a senha.';
  } else {
    $user = DB::one('SELECT * FROM users WHERE username = ?', [$usuario]);
    if ($user && password_verify($senha, $user['password_hash'])) {
      session_regenerate_id(true);
      $_SESSION['user_id'] = (int)$user['id'];
      redirect('index.php');
    } else {
      $erro = 'Credenciais inválidas.';
    }
  }
}

$ASSETS = assets_local();
?>
<!doctype html>
<html lang="pt-BR">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Login</title>
<?php foreach ($ASSETS['css'] as $css): ?>
<link rel="stylesheet" href="<?php echo h($css); ?>">
<?php endforeach; ?>
</head>
<body class="login-shell">
  <div class="login-card">
    <div class="login-title">Administrative Access</div>
    <div class="text-subtle mb-3">Use your administrator credentials.</div>

    <?php if ($erro): ?>
      <div class="alert alert-bad mb-3"><?php echo h($erro); ?></div>
    <?php endif; ?>

    <form method="post">
      <?php echo csrf_input(); ?>
      <label>User</label>
      <input name="username" autocomplete="username" required>

      <label class="mt-2">Password</label>
      <input name="password" type="password" autocomplete="current-password" required class="mb-2">

      <button class="btn" style="width:100%">To enter</button>
    </form>
  </div>

  <?php foreach ($ASSETS['js'] as $js): ?>
  <script src="<?php echo h($js); ?>"></script>
  <?php endforeach; ?>
</body>
</html>
