<?php
declare(strict_types=1);
require_once __DIR__ . '/config.php';
$current = basename($_SERVER['SCRIPT_NAME']);
$user = require_login();
enforce_first_login_redirect($user, $current);
$ASSETS = assets_local();
?><!doctype html><html lang="pt-BR"><head>
<meta charset="utf-8">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Nio Player</title>
<?php foreach ($ASSETS['css'] as $css): ?><link rel="stylesheet" href="<?php echo h($css); ?>"><?php endforeach; ?>
<link rel="icon" href="favicon.ico">

<style>
  /* Container principal */
  #app { display:flex; min-height:100vh; }
  
  /* Sidebar moderna */
  #app .sidebar { 
    width:16rem; 
    flex:0 0 16rem; 
    transition: width .3s cubic-bezier(0.4, 0, 0.2, 1); 
    overflow-x:hidden;
    display: flex;
    flex-direction: column;
    border-right: 1px solid rgba(255,255,255,0.1);
    position: fixed;
    top: 0;
    left: 0;
    height: 100vh;
    overflow-y: auto;
  }
  
  /* Collapsed state */
  #app.collapsed .sidebar { 
    width:4.5rem !important; 
    flex-basis:4.5rem !important; 
  }
  
  /* Header da sidebar */
  #app .sidebar .surface {
    padding: 1.5rem 1.25rem;
    border-bottom: 1px solid rgba(255,255,255,0.08);
  }
  
  #app .sidebar .brand {
    font-size: 1.25rem;
    font-weight: 700;
    letter-spacing: -0.02em;
  }
  
  #app .sidebar .brand-badge {
    display: inline-block;
    padding: 0.25rem 0.625rem;
    background: rgba(59, 130, 246, 0.15);
    border: 1px solid rgba(59, 130, 246, 0.3);
    border-radius: 0.375rem;
    font-size: 0.75rem;
    font-weight: 600;
    color: #60a5fa;
    text-transform: uppercase;
    letter-spacing: 0.05em;
  }
  
  /* Navegação espaçada */
  #app .sidebar nav {
    padding: 1.5rem 0.75rem;
    flex: 1;
    display: flex;
    flex-direction: column;
    gap: 0.375rem;
  }
  
  #app .sidebar nav .tile {
    display: flex;
    align-items: center;
    gap: 0.875rem;
    padding: 0.75rem 1rem;
    border-radius: 0.625rem;
    white-space: nowrap;
    transition: all 0.2s ease;
    font-weight: 500;
    position: relative;
  }
  
  #app .sidebar nav .tile:hover {
    background: rgba(255,255,255,0.08);
    transform: translateX(2px);
  }
  
  #app .sidebar nav .tile.active {
    background: rgba(59, 130, 246, 0.15);
    color: #60a5fa;
  }
  
  #app .sidebar nav .tile.active::before {
    content: '';
    position: absolute;
    left: 0;
    top: 50%;
    transform: translateY(-50%);
    width: 3px;
    height: 60%;
    background: #3b82f6;
    border-radius: 0 3px 3px 0;
  }
  
  #app .sidebar nav .tile .icon {
    width: 22px;
    height: 22px;
    flex: 0 0 22px;
  }
  
  /* Estado collapsed */
  #app.collapsed .sidebar nav .tile {
    justify-content: center;
    padding: 0.75rem;
  }
  
  #app.collapsed .sidebar nav .tile span {
    display: none;
  }
  
  #app.collapsed .sidebar nav .tile.active::before {
    display: none;
  }
  
  #app.collapsed .sidebar .surface .brand,
  #app.collapsed .sidebar .surface .text-subtle {
    display: none;
  }

  /* Botão de suporte no rodapé */
  .sidebar-footer {
    padding: 0.75rem;
    border-top: 1px solid rgba(255,255,255,0.08);
    margin-top: auto;
  }
  
  .support-btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 0.375rem 0.75rem;
    background: rgba(59, 130, 246, 0.15);
    border: 1px solid rgba(59, 130, 246, 0.3);
    border-radius: 0.375rem;
    color: #60a5fa;
    font-weight: 600;
    font-size: 0.75rem;
    text-decoration: none;
    text-transform: uppercase;
    letter-spacing: 0.05em;
    transition: all 0.2s ease;
    width: 100%;
    justify-content: center;
  }
  
  .support-btn:hover {
    background: rgba(59, 130, 246, 0.25);
    border-color: rgba(59, 130, 246, 0.5);
    transform: translateY(-1px);
  }
  
  .support-btn .icon {
    width: 16px;
    height: 16px;
    flex: 0 0 16px;
  }
  
  #app.collapsed .support-btn {
    justify-content: center;
    padding: 0.5rem;
  }
  
  #app.collapsed .support-btn span {
    display: none;
  }

  /* Topbar moderna */
  .nav-toggle {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    border: 1px solid rgba(255,255,255,0.1);
    border-radius: 0.625rem;
    background: rgba(255,255,255,0.05);
    cursor: pointer;
    margin-right: 1rem;
    transition: all 0.2s ease;
  }
  
  .nav-toggle:hover {
    background: rgba(255,255,255,0.1);
    border-color: rgba(255,255,255,0.2);
  }
  
  .nav-toggle svg {
    width: 20px;
    height: 20px;
  }

  /* Main content */
  main.flex-1 {
    min-width: 0;
    margin-left: 16rem;
    transition: margin-left .3s cubic-bezier(0.4, 0, 0.2, 1);
    height: 100vh;
    overflow-y: auto;
  }
  
  #app.collapsed main.flex-1 {
    margin-left: 4.5rem;
  }
  
  .page {
    display: block !important;
  }
  
  /* Topbar spacing */
  .topbar {
    display: flex;
    align-items: center;
    padding: 1.25rem 1.5rem;
    border-bottom: 1px solid rgba(255,255,255,0.08);
  }
  
  .topbar .title {
    font-size: 1.125rem;
    font-weight: 600;
    letter-spacing: -0.01em;
  }
</style>
</head><body class="min-h-screen"><div id="app" class="flex">

<aside class="w-64 sidebar min-h-screen">
  <div class="px-6 py-5 surface">
    <div class="text-sm text-subtle"><span class="brand-badge">ESSO4KDevelop</span></div>
    <div class="brand mt-2">Nio Player</div>
    <div class="text-xs text-subtle mt-1">Welcome<?php echo h($user['username']); ?></div>
  </div>
  
  <nav class="p-4 text-sm">
    <a class="<?php echo $current==='index.php'?'active ':'';?>tile" href="index.php">
      <svg class="icon" viewBox="0 0 24 24" fill="currentColor"><path d="M3 12h8V3H3v9zm0 9h8v-7H3v7zm10 0h8V12h-8v9zm0-18v7h8V3h-8z"/></svg>
      <span>Dashboard</span>
    </a>
    <a class="<?php echo $current==='nio_services.php'?'active ':'';?>tile" href="nio_services.php">
      <svg class="icon" viewBox="0 0 24 24" fill="currentColor"><path d="M4 7h16v2H4V7zm0 4h16v2H4v-2zm0 4h10v2H4v-2z"/></svg>
      <span>Services</span>
    </a>
    <a class="<?php echo $current==='nio_notifications.php'?'active ':'';?>tile" href="nio_notifications.php">
      <svg class="icon" viewBox="0 0 24 24" fill="currentColor"><path d="M12 22a2 2 0 0 0 2-2H10a2 2 0 0 0 2 2zm6-6V11a6 6 0 1 0-12 0v5L4 18v2h16v-2l-2-2z"/></svg>
      <span>Notifications</span>
    </a>
    <a class="<?php echo $current==='webview_pages.php'?'active ':'';?>tile" href="webview_pages.php">
      <svg class="icon" viewBox="0 0 24 24" fill="currentColor"><path d="M3 4h18v2H3V4zm0 4h18v10H3V8zm2 2v6h14v-6H5z"/></svg>
      <span>Sports Page</span>
    </a>
    <a class="<?php echo $current==='settings.php'?'active ':'';?>tile" href="settings.php">
      <svg class="icon" viewBox="0 0 24 24" fill="currentColor"><path d="M19.14 12.94a7.07 7.07 0 0 0 .05-.94 7.07 7.07 0 0 0-.05-.94l2.03-1.58a.5.5 0 0 0 .12-.64l-1.92-3.32a.5.5 0 0 0-.6-.22l-2.39.96a7.18 7.18 0 0 0-1.63-.94l-.36-2.54a.5.5 0 0 0-.5-.42h-3.84a.5.5 0 0 0-.5.42l-.36 2.54a7.18 7.18 0 0 0-1.63.94l-2.39-.96a.5.5 0 0 0-.6.22L2.66 7.84a.5.5 0 0 0 .12.64l2.03 1.58c-.03.31-.05.63-.05.94s.02.63.05.94L2.78 13.5a.5.5 0 0 0-.12.64l1.92 3.32c.12.2.37.29.6.22l2.39-.96c.5.37 1.05.69 1.63.94l.36 2.54a.5.5 0 0 0 .5.42h3.84a.5.5 0 0 0 .5-.42l.36-2.54c.58-.25 1.13-.57 1.63-.94l2.39.96c.23.07.48-.02.6-.22l1.92-3.32a.5.5 0 0 0-.12-.64l-2.03-1.58z"/></svg>
      <span>Settings</span>
    </a>
    <a class="tile" href="logout.php">
      <svg class="icon" viewBox="0 0 24 24" fill="currentColor"><path d="M10 17v2H4V5h6v2H6v10h4zm9-5-4-4v3h-5v2h5v3l4-4z"/></svg>
      <span>To go out</span>
    </a>
  </nav>
  
  <div class="sidebar-footer">
    <a href="https://esso4k-tv.com/" target="_blank" class="support-btn">
      <svg class="icon" viewBox="0 0 24 24" fill="currentColor">
        <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413Z"/>
      </svg>
      <span>Support</span>
    </a>
  </div>
</aside>

<main class="flex-1">
  <div class="topbar">
    <button id="sidebarToggle" class="nav-toggle" type="button" aria-label="Alternar menu lateral">
      <svg viewBox="0 0 24 24" fill="currentColor"><path d="M3 6h18v2H3V6zm0 5h18v2H3v-2zm0 5h18v2H3v-2z"/></svg>
    </button>
    <div class="title">Nio Player</div>
    <div class="quick-actions"></div>
  </div>
  <div class="p-6 page">
    <?php if ($msg = flash('info')): ?><div class="mb-4 alert alert-info"><?php echo h($msg); ?></div><?php endif; ?>



<script>
  (function(){
    var app = document.getElementById('app');
    var btn = document.getElementById('sidebarToggle');
    var KEY = 'sidebarCollapsed';
    try { if (localStorage.getItem(KEY) === '1') app.classList.add('collapsed'); } catch(e){}
    btn.addEventListener('click', function(){
      app.classList.toggle('collapsed');
      try { localStorage.setItem(KEY, app.classList.contains('collapsed') ? '1' : '0'); } catch(e){}
    });
  })();
</script>