<?php
declare(strict_types=1);
function h(?string $s): string { return htmlspecialchars($s ?? '', ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
function redirect(string $path): void { header('Location: ' . $path); exit; }
function flash(string $key, ?string $val = null): ?string {
  if ($val === null) { if (!empty($_SESSION['flash'][$key])) { $m=$_SESSION['flash'][$key]; unset($_SESSION['flash'][$key]); return $m; } return null; }
  $_SESSION['flash'][$key] = $val; return null;
}
function csrf_token(): string { if (empty($_SESSION['csrf_token'])) $_SESSION['csrf_token'] = bin2hex(random_bytes(32)); return $_SESSION['csrf_token']; }
function csrf_input(): string { return '<input type="hidden" name="csrf_token" value="'.h(csrf_token()).'">'; }
function require_csrf(): void {
  $t = $_POST['csrf_token'] ?? $_SERVER['HTTP_X_CSRF_TOKEN'] ?? '';
  if (!$t || !hash_equals((string)($_SESSION['csrf_token'] ?? ''), (string)$t)) { http_response_code(400); echo 'Invalid CSRF token'; exit; }
}
function require_login(): array {
  if (empty($_SESSION['user_id'])) redirect('login.php');
  $u = DB::one('SELECT * FROM users WHERE id=?', [(int)$_SESSION['user_id']]);
  if (!$u) { session_destroy(); redirect('login.php'); }
  return $u;
}
function enforce_first_login_redirect(array $user, string $current): void {
  if ((int)($user['must_change'] ?? 0) === 1 && $current !== 'settings.php' && $current !== 'logout.php') {
    redirect('settings.php');
  }
}
// Deterministic 6-digit device key
function device_key_from_mac(string $mac): string {
  $norm = strtolower(preg_replace('/[^0-9a-f]/i', '', $mac ?? ''));
  $n = sprintf('%u', crc32($norm));
  $dk = (int)$n % 900000 + 100000;
  return strval($dk);
}
function app_stats(): array {
  $d = DB::one('SELECT COUNT(*) AS c FROM devices'); $p = DB::one('SELECT COUNT(*) AS c FROM playlists');
  $pa = DB::one('SELECT COUNT(*) AS c FROM playlists WHERE active=1'); $s = DB::one('SELECT COUNT(*) AS c FROM services');
  return ['devices'=>(int)($d['c']??0),'playlists'=>(int)($p['c']??0),'playlists_active'=>(int)($pa['c']??0),'services'=>(int)($s['c']??0)];
}
function assets_local(): array { return ['css'=>['assets/cruip-compiled/css/app.css'],'js'=>['assets/cruip-compiled/js/app.js','assets/cruip-compiled/js/charts.js']]; }
