<?php
declare(strict_types=1);
final class DB {
  private static ?\PDO $pdo = null;
  public static function conn(): \PDO {
    if (self::$pdo === null) {
      $pdo = new \PDO('sqlite:' . DB_PATH, null, null, [
        \PDO::ATTR_ERRMODE=>\PDO::ERRMODE_EXCEPTION,
        \PDO::ATTR_DEFAULT_FETCH_MODE=>\PDO::FETCH_ASSOC,
        \PDO::ATTR_EMULATE_PREPARES=>false
      ]);
      $pdo->exec('PRAGMA foreign_keys = ON');
      $pdo->exec('PRAGMA journal_mode = WAL');
      $pdo->exec('PRAGMA busy_timeout = 5000');
      self::$pdo = $pdo;
    }
    return self::$pdo;
  }
  public static function one(string $sql, array $p=[]): ?array{ $s=self::conn()->prepare($sql);$s->execute($p);$r=$s->fetch();return $r===false?null:$r; }
  public static function all(string $sql, array $p=[]): array{ $s=self::conn()->prepare($sql);$s->execute($p);return $s->fetchAll(); }
  public static function exec(string $sql, array $p=[]): int{ $s=self::conn()->prepare($sql);$s->execute($p);return $s->rowCount(); }
  public static function id(): int { return (int)self::conn()->lastInsertId(); }
}
