<?php
declare(strict_types=1);
error_reporting(E_ALL & ~E_NOTICE);
ini_set('display_errors', '0');

define('DB_PATH', __DIR__ . '/app.sqlite');

ini_set('session.use_strict_mode', '1');
ini_set('session.use_only_cookies', '1');
ini_set('session.cookie_httponly', '1');
function start_secure_session(): void {
  if (session_status() === PHP_SESSION_NONE) {
    $params = [
      'lifetime' => 0, 'path' => '/', 'domain' => '',
      'secure' => (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off'),
      'httponly' => true, 'samesite' => 'Strict'
    ];
    @session_set_cookie_params($params);
    session_name('SPECTERSESSID');
    @session_start();
  }
}
start_secure_session();

// (backup/restore removed; no server keys needed)

require_once __DIR__ . '/db.php';
require_once __DIR__ . '/functions.php';
require_once __DIR__ . '/migrations.php';
run_migrations();
