
(function(){
  function drawAxes(ctx, w, h, padding){
    ctx.strokeStyle = 'rgba(255,255,255,0.2)'; ctx.lineWidth=1;
    ctx.beginPath(); ctx.moveTo(padding, h-padding); ctx.lineTo(w-padding, h-padding); ctx.stroke();
    ctx.beginPath(); ctx.moveTo(padding, padding); ctx.lineTo(padding, h-padding); ctx.stroke();
  }
  function norm(v,min,max){ if(max===min) return 0.5; return (v-min)/(max-min); }
  function lineChart(canvas, labels, values){
    if(!canvas) return;
    var ctx = canvas.getContext('2d'), w=canvas.width, h=canvas.height, pad=32;
    ctx.clearRect(0,0,w,h); drawAxes(ctx,w,h,pad);
    var min = Math.min.apply(null, values.concat([0])), max=Math.max.apply(null, values.concat([1]));
    var step = (w-2*pad)/(Math.max(1,values.length-1));
    ctx.beginPath(); ctx.lineWidth=2; ctx.strokeStyle='#7aa2ff';
    values.forEach(function(v,i){
      var x = pad + i*step;
      var y = h - pad - norm(v,min,max)*(h-2*pad);
      if(i===0) ctx.moveTo(x,y); else ctx.lineTo(x,y);
    });
    ctx.stroke();
    ctx.fillStyle='rgba(122,162,255,0.15)'; ctx.lineTo(w-pad, h-pad); ctx.lineTo(pad, h-pad); ctx.closePath(); ctx.fill();
    ctx.fillStyle='#c7d6ff';
    values.forEach(function(v,i){
      var x = pad + i*step;
      var y = h - pad - norm(v,min,max)*(h-2*pad);
      ctx.beginPath(); ctx.arc(x,y,2.5,0,Math.PI*2); ctx.fill();
    });
  }
  function barChart(canvas, labels, values){
    if(!canvas) return;
    var ctx = canvas.getContext('2d'), w=canvas.width, h=canvas.height, pad=32;
    ctx.clearRect(0,0,w,h); drawAxes(ctx,w,h,pad);
    var min = 0, max=Math.max.apply(null, values.concat([1]));
    var n=values.length, bw=(w-2*pad)/Math.max(1,n)*0.7, gap=n>1?((w-2*pad)-n*bw)/(n-1):0;
    values.forEach(function(v,i){
      var x = pad + i*(bw+gap);
      var y = h - pad - (v/max)*(h-2*pad);
      var hh = h - pad - y;
      ctx.fillStyle='rgba(122,162,255,0.8)';
      ctx.fillRect(x,y,bw,hh);
    });
  }
  window.SpecterCharts = { lineChart, barChart };
})(); 
