<?php
ini_set("display_errors", 1);
$db = new SQLite3("./api/.db.db");

// Se a solicitação for um POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verifica se o parâmetro 'delete' foi enviado
    if (isset($_POST['delete'])) {
        $itemToDelete = $_POST['delete'];

        // Evite injeção SQL usando declarações preparadas
        $stmt = $db->prepare("DELETE FROM playlist WHERE id = :id");
        $stmt->bindValue(':id', $itemToDelete, SQLITE3_INTEGER);
        
        // Execute a exclusão
        if ($stmt->execute()) {
            // A exclusão foi bem-sucedida
            echo json_encode(array('status' => 'success'));
        } else {
            // A exclusão falhou
            echo json_encode(array('status' => 'error'));
        }
        
        exit;
    }
}
include './includes/header.php';
?>
<?php
$table_name = "playlist";
$res = $db->select($table_name, "*", "");

// Adiciona novo usuário
if (isset($_POST["submit"])) {
    unset($_POST["submit"]);

    // Verifica se o tipo está definido e é 'm3u'
    if (isset($_POST['type']) && $_POST['type'] === 'm3u') {
        $url = $_POST['url'];

        // Verifica se a URL contém '/get.php'
        if (strpos($url, '/get.php') !== false) {
            $dnsUrl = substr($url, 0, strpos($url, '/get.php'));
            $dnsUrl = rtrim($dnsUrl);
        } else {
            $dnsUrl = ''; // Garante que a variável não seja nula
        }

        // Obtém username e password
        parse_str(parse_url($url, PHP_URL_QUERY), $queryParams);
        $username = isset($queryParams['username']) ? $queryParams['username'] : '';
        $password = isset($queryParams['password']) ? $queryParams['password'] : '';

        // Gera um novo ID para dns_id
        $dns_id = generateNewDnsId();

        // Prepara os dados para inserção na tabela playlist
        $_POST['username'] = $username;
        $_POST['password'] = $password;
        $_POST['dns_id'] = $dns_id;

        // Adiciona na tabela dns
        $dnsData = [
            'id' => $dns_id,
            'title' => 'new',
            'url' => $dnsUrl
        ];

        // Insere na tabela dns
        if ($db->insert('dns', $dnsData)) {
            echo "<script>showNotification('DNS adicionado com sucesso!', 'success');</script>";
        } else {
            echo "<script>showNotification('Erro ao adicionar DNS!', 'error');</script>";
        }
    } else {
        echo "<script>showNotification('Tipo não especificado!', 'error');</script>";
    }

    // Insere os dados na tabela playlist
    $db->insert($table_name, $_POST);
    echo "<script>window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=1'</script>";
}

function generateNewDnsId() {
    global $db;
    $result = $db->select('dns', 'MAX(id) as max_id');
    return ($result[0]['max_id'] ?? 0) + 1; // Incrementa o ID máximo existente
}

// Atualiza usuário
if (isset($_GET["update"])) {
    $resU = $db->select($table_name, "*", "id = :id", "", [":id" => $_GET["update"]]);
    if ($resU) {
        $userData = $resU[0]; // Pega os dados do usuário para editar
    }
}

if (isset($_POST["submitU"])) {
    unset($_POST["submitU"]);
    $updateData = $_POST;
    $db->update($table_name, $updateData, "id = :id", [":id" => $_GET["update"]]);
    echo "<script>window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=1'</script>";
}

// Deleta usuário
if (isset($_GET["delete"])) {
    $db->delete($table_name, "id = :id", [":id" => $_GET["delete"]]);
    // Conectar ao banco de dados SQLite
    $db = new SQLite3('permissoes.db');
    $db->busyTimeout(5000); // Espera até 5 segundos antes de retornar "database is locked"
    
    $mac_address = isset($_GET['mac_address']) ? $_GET['mac_address'] : null;
    
    // Verificar se o mac_address foi passado
    if ($mac_address) {
        // Preparar a consulta para deletar a linha com o mac_address fornecido
        $stmt = $db->prepare("DELETE FROM permissoes WHERE mac_address = :mac_address");
        $stmt->bindValue(':mac_address', $mac_address, SQLITE3_TEXT);
    
        // Executar a consulta
        $result = $stmt->execute();
    }
    echo "<script>window.location.href='" . basename($_SERVER["SCRIPT_NAME"]) . "?status=2'</script>";
}
?>
<?php
// Formulário de criação ou edição
if (isset($_GET["create"]) || isset($_GET["update"])) {
    $action = isset($_GET["update"]) ? 'Editar Usuário' : 'Adicionar Usuário';
    echo '<div class="card radius-10">
            <div class="card-body">
                <div class="card-title" style="border:none;">
                    <div class="card-header card-header-warning text-center">
                        <h2><i class="icon icon-bullhorn"></i> ' . $action . '</h2>
                    </div>
                    <div class="card-body">
                        <form method="post">
                            <!-- Campos para seleção entre DNS e M3U -->
                            <div class="form-group">
                                <label class="form-label" for="type">Selecionar Tipo</label>
                                <select class="form-control" id="type" name="type" onchange="toggleFields()">
                                    <option value="" selected>Selecionar uma opção</option>
                                    <option value="dns"' . (isset($userData) && $userData["type"] == "dns" ? ' selected' : '') . '>Selecionar DNS</option>
                                    <option value="m3u"' . (isset($userData) && $userData["type"] == "m3u" ? ' selected' : '') . '>Selecionar M3u</option>
                                </select>
                            </div>';

    // Campos de DNS
    echo '<div id="dns-fields" style="display: ' . (isset($userData) && $userData["type"] == "dns" ? 'block' : 'none') . ';"><div class="form-group">
            <label class="form-label" for="dns_id">DNS</label>
            <select class="form-control" name="dns_id">';
    $dnss = $db->select("dns", "*", "title != :title", "", [":title" => "new"]);
    foreach ($dnss as $dns) {
        echo '<option value="' . $dns["id"] . '"' . (isset($userData) && $userData["dns_id"] == $dns["id"] ? ' selected' : '') . '>' . $dns["title"] . '</option>';
    }
    echo '</select></div></div>';

    // Campos de M3U
    echo '<div id="m3u-fields" style="display: ' . (isset($userData) && $userData["type"] == "m3u" ? 'block' : 'none') . ';"><div class="form-group">
                <label class="form-label" for="mac">Endereço MAC</label>
                <input class="form-control" id="mac" name="mac_address" placeholder="Endereço MAC" type="text" value="' . (isset($userData) ? $userData["mac_address"] : '') . '" onkeyup="formatMac(this)"/>
            </div><br>
            <div class="form-group">
                <label class="form-label" for="url">URL</label>
                <input class="form-control" id="url" name="url" placeholder="URL" type="text" value="' . (isset($userData) ? $userData["url"] : '') . '"/>
            </div></div>';

    // Campos comuns
    echo '<div id="common-fields" style="display: none;">
            <div class="form-group">
                <label class="form-label" for="mac">Endereço MAC</label>
                <input class="form-control" id="mac" name="mac_address" placeholder="Endereço MAC" type="text" value="' . (isset($userData) ? $userData["mac_address"] : '') . '" onkeyup="formatMac(this)"/>
            </div><br>
            <div class="form-group">
                <label class="form-label" for="username">Nome de Usuário</label>
                <input class="form-control" id="username" name="username" placeholder="Nome de Usuário" type="text" value="' . (isset($userData) ? $userData["username"] : '') . '"/>
            </div><br>
            <div class="form-group">
                <label class="form-label" for="password">Senha</label>
                <input class="form-control" id="password" name="password" placeholder="Senha" type="text" value="' . (isset($userData) ? $userData["password"] : '') . '"/>
            </div><br>
            <div class="form-group">
                <label class="form-label" for="pin">Parental Pin</label>
                <input class="form-control" id="pin" name="pin" placeholder="Parental Pin" type="text" value="' . (isset($userData) ? $userData["pin"] : '0000') . '"/>
            </div><br>
            <div class="form-group">
                <label class="form-label" for="link">Link</label>
                <input class="form-control" id="link" name="link" placeholder="Link" type="text" value="' . (isset($userData) ? $userData["link"] : '') . '"/>
            </div>
        </div>';

    // Botão de envio
    echo '<div class="form-group text-center">
            <button style="margin-top:15px;" class="btn btn-primary mr-2" name="' . (isset($_GET["update"]) ? 'submitU' : 'submit') . '" type="submit">
                <i class="bx bx-check mr-1"></i> ' . (isset($_GET["update"]) ? 'Atualizar' : 'Enviar') . '
            </button>
        </div>
    </form>
</div>
</div>
</div>
</div>';

 // Função JavaScript para formatação do MAC
    echo '<script>
    function formatMac(input) {
        var value = input.value.replace(/[^A-Fa-f0-9]/g, "");
        var formatted = value.match(/.{1,2}/g)?.join(":") || "";
        input.value = formatted.slice(0, 17);
    }


function toggleFields() {
    var type = document.getElementById("type").value;
    document.getElementById("common-fields").style.display = type ? "block" : "none"; 
    document.getElementById("dns-fields").style.display = (type === "dns") ? "block" : "none";
    document.getElementById("m3u-fields").style.display = (type === "m3u") ? "block" : "none";
}

document.addEventListener("DOMContentLoaded", function() {
    toggleFields();
});
</script>';
    
} else {
?>
<div class="card radius-10">
    <div class="card-header border-bottom-0 bg-transparent">
        <div class="d-flex align-items-center">
            <div>
                <h5 class="font-weight-bold mb-0">Usuarios Registrados</h5>
            </div>
            <div class="ms-auto">
                <a href="./playlists.php?create=1">
                    <button type="button" class="btn btn-primary mr-2 radius-10">Agregar Usuario</button>
                </a>
            </div>
        </div>
    </div>
    <div class="card-body">
        <!-- Título da Página -->
    <div class="col-12">
                	<center>
						
	        		
	        		</center>
<script>
$(document).ready(function() {
    $('#select-all').click(function() {
        $('input[name="selected_items[]"]').prop('checked', this.checked);
    });

    $(document).on("click", ".delete-item", function() {
        var itemId = $(this).data("id");

        if (confirm("Tem certeza de que deseja excluir este item?")) {
            $.post("users.php", { delete: itemId }, function(data) {
                if (data.status === 'success') {
                    // Exclusão bem-sucedida
                    window.location.href = "users.php?r=excluido";
                } else {
                    // Falha na exclusão
                    alert("Falha na exclusão do item com ID " + itemId);
                }
            }, 'json');
        }
    });

    $(document).on("click", "#delete-selected", function() {
        var selectedItems = [];

        $.each($("input[name='selected_items[]']:checked"), function(){
            selectedItems.push($(this).val());
        });

        if (selectedItems.length > 0) {
            if (confirm("Seguro que desea eliminar los usuarios seleccionados?")) {
                // Crie uma variável para rastrear o número de exclusões bem-sucedidas
                var successfulDeletes = 0;

                $.each(selectedItems, function(index, value) {
                    $.post("users.php", { delete: value }, function(data) {
                        if (data.status === 'success') {
                            successfulDeletes++;
                        }
                        
                        if (successfulDeletes === selectedItems.length) {
                            window.location.href = "users.php?r=all_excluido";
                        }
                    }, 'json');
                });
            }
        } else {
            alert("Selecione porlo menos un usuario para eliminar.");
        }
    });
});
</script>
    			</div>
				<br>
        
        <div class="table-responsive">
            <table id="myTable" class="table mb-0 align-middle">
                <thead>
                    <tr>
                       
                         <th>Dns </th>
                        <th>MAC del Dispositivo</th>
                        <th>Usuario</th>
                        
                        <th>Contraseña</th>
                        <th>Parental Pin</th>
                        <th>Link</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                   <?php
$db = new SQLite3("./api/.db.db");
$res = $db->query("SELECT * FROM playlist");

while ($row = $res->fetchArray()) {
    echo '<tr>
        <td>' . $row["dns_id"] . '</td>
        <td>' . $row["mac_address"] . '</td>
        <td>' . $row["username"] . '</td>
        <td>' . $row["password"] . '</td>
        <td>' . $row["pin"] . '</td>
        <td>' . $row["link"] . '</td>
        <td>
            <a href="' . basename($_SERVER["SCRIPT_NAME"]) . '?update=' . $row["id"] . '" class="btn btn-warning btn-sm" title="Editar">
                <i class="bx bx-pencil"></i>
            </a>
            <a href="' . basename($_SERVER["SCRIPT_NAME"]) . '?message=' . $row["mac_address"] . '" class="btn btn-info btn-sm" title="Mensagem">
    <i class="bx bx-mail-send"></i>
</a>

            <a href="#" class="btn btn-success btn-sm" data-toggle="modal" data-target="#permissoesModal" onclick="modalExibido(\'' . $row['mac_address'] . '\');" data-id="' . $row["mac_address"] . '" title="Permissões">
                <i class="bx bxs-lock"></i>
            </a>
            <a href="' . basename($_SERVER["SCRIPT_NAME"]) . '?delete=' . $row["id"] . '&mac_address=' . $row["mac_address"] . '" class="btn btn-danger btn-sm" title="Deletar">
                <i class="bx bxs-x-circle"></i>
            </a>
        </td>
    </tr>';
}
?>
<!-- Caixa de Diálogo -->
<div id="dialog" style="display:none;">
    <form id="editForm">
        <label for="mac_address">MAC Address:</label>
        <input type="text" id="mac_address" name="mac_address" readonly><br>

        <label for="mac_value">Mensaje:</label>
        <input type="text" id="mac_value" name="mac_value"><br>

        <button type="submit">Guardar</button>
        <button type="button" onclick="closeDialog()">Regresar</button>
    </form>
</div>

<script>
    // Función para capturar el parámetro 'message' de la URL
    function getQueryParam(param) {
        const urlParams = new URLSearchParams(window.location.search);
        return urlParams.get(param);
    }

    // Obtener el 'mac_address' de la URL
    const mac_address = getQueryParam('message');

    // Mostrar el valor obtenido de la URL en la consola para depuración
    console.log("MAC Address del URL: " + mac_address);

    // Verificar si el 'mac_address' está presente en la URL
    if (mac_address) {
        // Normalizar el 'mac_address' a mayúsculas y eliminar espacios extras
        const normalizedMacAddress = mac_address.toUpperCase().trim();

        // Mostrar el valor normalizado en la consola para depuración
        console.log("MAC Address normalizado: " + normalizedMacAddress);

        // Cargar los datos desde el archivo JSON
        fetch('./api/device_keys.json?' + new Date().getTime())
            .then(response => response.json())
            .then(data => {
                // Mostrar el contenido del JSON en la consola para depuración
                console.log("Contenido del JSON: ", data);

                // Verificar si el 'mac_address' existe en el JSON, usando el formato normalizado
                if (data[normalizedMacAddress]) {
                    document.getElementById("mac_address").value = normalizedMacAddress;
                    document.getElementById("mac_value").value = data[normalizedMacAddress];

                    // Mostrar el diálogo
                    document.getElementById("dialog").style.display = "block";
                } else {
                    alert("MAC Address no encontrado.");
                }
            })
            .catch(error => {
                alert("Error al cargar el archivo JSON.");
                console.error(error);
            });
    }

    // Función para cerrar el cuadro de diálogo
    function closeDialog() {
        document.getElementById("dialog").style.display = "none";
    }

    // Evento para enviar el formulario y guardar los datos editados
    document.getElementById("editForm").addEventListener("submit", function(event) {
        event.preventDefault();

        const mac_address = document.getElementById("mac_address").value;
        const mac_value = document.getElementById("mac_value").value;

        // Validar que los campos no estén vacíos
        if (!mac_address || !mac_value) {
            alert("Por favor, complete todos los campos.");
            return;
        }

        console.log("Guardando datos: ", mac_address, mac_value);

        // Actualizar el archivo JSON
        fetch('update_device_key.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ mac_address: mac_address, mac_value: mac_value })
        })
        .then(response => response.json())
        .then(data => {
            console.log("Respuesta del servidor:", data);
            alert(data.message);
            closeDialog();
        })
        .catch(error => {
            console.error("Error al guardar los datos:", error);
            alert("Error al guardar los datos.");
        });
    });
</script>
                </tbody>
<?php
if (isset($_GET["r"])) {
    $result = $_GET["r"];
    switch ($result) {
        case "atualizado":
            echo "<script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 2000,
            })
            Toast.fire({
                icon: 'success',
                title: 'Usuario Actualizado con Exito!'
            })</script>";
            break;
        case "erro_att":
            echo "<script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 2000,
            })
            Toast.fire({
                icon: 'error',
                title: 'Error al Actualizar Usuario!'
            })</script>";
            break;
        case "adicionado":
            echo "<script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 2000,
            })
            Toast.fire({
                icon: 'success',
                title: 'Usuario Agregado con Exito!'
            })</script>";
            break;
        case "excluido":
            echo "<script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 2000,
            })
            Toast.fire({
                icon: 'success',
                title: 'Usuário Eliminado con Exito!'
            })</script>";
            break;
        case "all_excluido":
            echo "<script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 2000,
            })
            Toast.fire({
                icon: 'success',
                title: 'Usuarios Eliminados com Exito!'
            })</script>";
            break;
            
    }
}
?>
<?php } ?>
<?php include './includes/footer.php'; ?>
<script>
     // Quando o modal for mostrado
    function modalExibido(id) {

    $("#modalID").text('MAC do usuário: ' + id);

    // Obter as permissões do servidor para o mac_address
    axios.get('processar_permissoes_buscar.php', {
        params: {
            mac_address: id
        }
    })
    .then(function(response) {
        if (response.data.status === 'sucesso') {
            var permissoes = response.data.dados;
            console.log(permissoes);

            // Verificar e marcar os checkboxes com base nas permissões
            if (permissoes.permissao_filmes === 'sim') {
                $('#filmesCheckbox').prop('checked', true);
            } else {
                $('#filmesCheckbox').prop('checked', false);
            }

            if (permissoes.permissao_canais === 'sim') {
                $('#canaisCheckbox').prop('checked', true);
            } else {
                $('#canaisCheckbox').prop('checked', false);
            }

            if (permissoes.permissao_series === 'sim') {
                $('#seriesCheckbox').prop('checked', true);
            } else {
                $('#seriesCheckbox').prop('checked', false);
            }
            
            
      // Lidar com o botão de envio
    $('#enviarPermissoes').click(function() {
        // Coletar os checkboxes marcados
        var permissoesSelecionadas = [];
        
        if ($('#filmesCheckbox').is(':checked')) {
            permissoesSelecionadas.push('Filmes');
        }
        if ($('#canaisCheckbox').is(':checked')) {
            permissoesSelecionadas.push('Canais');
        }
        if ($('#seriesCheckbox').is(':checked')) {
            permissoesSelecionadas.push('Séries');
        }
        
        // Verificar se algum checkbox foi marcado
        if (permissoesSelecionadas.length > 0) {
            // Enviar a requisição axios com os dados
            axios.post('processar_permissoes.php', {
                mac_address: id,
                permissoes: permissoesSelecionadas
            })
            .then(function(response) {
                console.log(response.data);
                alert('Permissões enviadas com sucesso!');
                window.location.reload();
            })
            .catch(function(error) {
                console.error(error);
                alert('Erro ao enviar permissões');
            });
        } else {
            alert('Por favor, selecione porlo menos un permiso.');
        }
    });

        } else {
            alert('Error al buscar permisos: ' + response.data.mensagem);
        }
    })
    .catch(function(error) {
        console.error(error);
        alert('Erro al buscar permisos.');
    });
}
</script>


