<?php
// Caminho do arquivo de log dentro da pasta 'api'
$logFilePath = __DIR__ . '/api/connection_log.json';

// Função para formatar o tempo online de segundos para minutos e segundos
function formatTime($seconds) {
    $minutes = floor($seconds / 60); // Calcular minutos
    $remainingSeconds = $seconds % 60; // Calcular os segundos restantes
    return sprintf("%02d:%02d", $minutes, $remainingSeconds); // Retorna o tempo no formato mm:ss
}

// Ler os registros do log
$logData = json_decode(file_get_contents($logFilePath), true);

// Verificar se houve erro ao decodificar o JSON
if ($logData === null) {
    die("Erro ao ler o arquivo JSON: " . json_last_error_msg());
}

// Garantir que $logData seja um array válido
if (!is_array($logData)) {
    $logData = [];
}

// Incluir o cabeçalho da página
include "includes/header.php";
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Status Monitor</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
            color: #333;
        }

        h1 {
            text-align: center;
            margin-top: 20px;
            color: white; /* Cor do título alterada para branco */
            background-color: #333; /* Cor de fundo para o título */
            padding: 10px;
            border-radius: 8px;
        }

        table {
            width: 80%;
            margin: 30px auto;
            border-collapse: collapse;
            border-radius: 8px;
            overflow: hidden;
        }

        th, td {
            padding: 12px;
            text-align: left;
            border: 1px solid #ddd;
        }

        th {
            background-color: #333;
            color: white;
        }

        td {
            background-color: #fff;
        }

        tr:nth-child(even) td {
            background-color: #f9f9f9;
        }

        .status {
            text-align: center;
            font-weight: bold;
            padding: 8px;
            border-radius: 4px;
        }

        .online-time {
            background-color: #4CAF50; /* Verde */
            color: white;
        }

        .offline-time {
            background-color: #f44336; /* Vermelho */
            color: white;
        }

        .no-data {
            text-align: center;
            font-style: italic;
            color: #888;
        }
    </style>
</head>
<body>

    <h1>Status Monitor</h1>
    
    <table>
        <thead>
            <tr>
                <th>Codigo de Acesso</th>
                <th>Último Visto Online</th>
                <th>Tempo Online</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($logData)): ?>
                <?php foreach ($logData as $entry): ?>
                    <tr>
                        <td><?= htmlspecialchars($entry['mac_address'] ?? 'N/A') ?></td>
                        <td><?= htmlspecialchars($entry['date'] ?? 'N/A') ?></td>
                        <td class="status <?= isset($entry['total_online_time']) && is_numeric($entry['total_online_time']) && $entry['total_online_time'] > 0 ? 'online-time' : 'offline-time' ?>">
                            <?php
                                // Exibir o tempo online no formato mm:ss, considerando 'total_online_time'
                                if (isset($entry['total_online_time']) && is_numeric($entry['total_online_time'])) {
                                    echo formatTime((int)$entry['total_online_time']); // Mostra o tempo em mm:ss
                                } else {
                                    echo '0:00'; // Se não houver tempo, mostra 0:00
                                }
                            ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="3" class="no-data">No connection logs found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

</body>
</html>

<?php
// Incluir o rodapé da página
include "includes/footer.php";
?>
