<?php
session_start();
$id = $_SESSION['id'];
$db1 = new SQLite3("./api/db/studiolivecode_users.db");

// Consulta para obter informações de admin e nível do usuário
$query = $db1->prepare("SELECT admin FROM users WHERE id = :id");
$query->bindValue(':id', $id, SQLITE3_INTEGER);
$userData = $query->execute()->fetchArray(SQLITE3_ASSOC);

// Verifica se o usuário é administrador (admin = 1) ou tem o nível necessário
if (!$userData || $userData['admin'] != 1) {
    header("Location: users.php");
    exit;
}

$db = new SQLite3("./api/db/studiolivecode_clientes.db");

// Se a solicitação for um POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verifica se o parâmetro 'delete' foi enviado
    if (isset($_POST['delete'])) {
        $itemToDelete = $_POST['delete'];

        // Evite injeção SQL usando declarações preparadas
        $stmt = $db->prepare("DELETE FROM ibo WHERE id = :id");
        $stmt->bindValue(':id', $itemToDelete, SQLITE3_INTEGER);
        
        // Execute a exclusão
        if ($stmt->execute()) {
            // A exclusão foi bem-sucedida
            echo json_encode(array('status' => 'success'));
        } else {
            // A exclusão falhou
            echo json_encode(array('status' => 'error'));
        }
        
        exit;
    }
}

include './includes/header.php';
?>

<div class="card radius-10">
    <div class="card-header border-bottom-0 bg-transparent">
        <div class="d-flex align-items-center">
            <div>
                <h5 class="font-weight-bold mb-0">Usuários Cadastrados</h5>
            </div>
            <div class="ms-auto">
                <a href="./users_create.php">
                    <button type="button" class="btn btn-primary mr-2 radius-10">Adicionar Usuário</button>
                </a>
            </div>
        </div>
    </div>
    <div class="card-body">
        <!-- Título da Página -->
    <div class="col-12">
                	<center>
						
	        			<button type="submit" id="delete-selected" name="delete-selected" class="btn btn-danger mr-2"><i class='bx bx-check mr-1'></i>Excluir Selecionados</button>
	        		</center>
<script>
$(document).ready(function() {
    $('#select-all').click(function() {
        $('input[name="selected_items[]"]').prop('checked', this.checked);
    });

    $(document).on("click", ".delete-item", function() {
        var itemId = $(this).data("id");

        if (confirm("Tem certeza de que deseja excluir este item?")) {
            $.post("all_users.php", { delete: itemId }, function(data) {
                if (data.status === 'success') {
                    // Exclusão bem-sucedida
                    window.location.href = "all_users.php?r=excluido";
                } else {
                    // Falha na exclusão
                    alert("Falha na exclusão do item com ID " + itemId);
                }
            }, 'json');
        }
    });

    $(document).on("click", "#delete-selected", function() {
        var selectedItems = [];

        $.each($("input[name='selected_items[]']:checked"), function(){
            selectedItems.push($(this).val());
        });

        if (selectedItems.length > 0) {
            if (confirm("Tem certeza de que deseja excluir os itens selecionados?")) {
                // Crie uma variável para rastrear o número de exclusões bem-sucedidas
                var successfulDeletes = 0;

                $.each(selectedItems, function(index, value) {
                    $.post("all_users.php", { delete: value }, function(data) {
                        if (data.status === 'success') {
                            successfulDeletes++;
                        }
                        
                        if (successfulDeletes === selectedItems.length) {
                            window.location.href = "all_users.php?r=all_excluido";
                        }
                    }, 'json');
                });
            }
        } else {
            alert("Selecione pelo menos um item para excluir.");
        }
    });
});
</script>
    			</div>
				<br>
        
        <div class="table-responsive">
            <table id="myTable" class="table mb-0 align-middle">
                <thead>
                    <tr>
                        <th style="display: none;">id</th>
                        <th>
                    <input type="checkbox" id="select-all">
                </th>
                        <th>MAC do Dispositivo</th>
                        <th>Key</th>
                        <th>Dns</th>
                        <th>Título</th>
                        <th>Vencimento</th>
                        <th>Editar</th>
                        <th>Deletar</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $res = $db->query("SELECT * FROM ibo ORDER BY id DESC");

                    while ($row = $res->fetchArray()) {
                        $iid = $row["id"];
                        $imac = $row["mac_address"];
                        $ikey = $row["key"];
                        $idns = $row["dns"];
                        $iexpire_date = $row["expire_date"];
                        $ititle = $row["title"];
                        ?>
                        <tr>
                            <td style="display: none;"><?php echo $iid; ?></td>
                            <td><input type="checkbox" name="selected_items[]" value="<?php echo $iid; ?>"></td>
                            <td><?php echo $imac; ?></td>
                            <td><?php echo $ikey; ?></td>
                            <td><?php echo $idns; ?></td>
                            <td><?php echo $ititle; ?></td>
                            <td><?php echo date('d/m/Y', strtotime($iexpire_date)); ?></td>
                            <td>
                                <div class="d-flex order-actions">
                                    <a href="./users_update.php?update=<?php echo $iid; ?>" class="text-light bg-primary border-0"><i class='bx bxs-edit'></i></a>
                                </div>
                            </td>
                            <td>
                           <div class="d-flex order-actions">
                          <a href="javascript:void(0);" class="text-light bg-danger border-0 delete-item" data-id="<?php echo $iid; ?>">
                        <i class="bx bxs-trash"></i>
                    </a>
                       </div>
										</td>
                        </tr>
                    <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php
if (isset($_GET["r"])) {
    $result = $_GET["r"];
    switch ($result) {
        case "atualizado":
            echo "<script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 2000,
            })
            Toast.fire({
                icon: 'success',
                title: 'Usuário Atualizado com Sucesso!'
            })</script>";
            break;
        case "erro_att":
            echo "<script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 2000,
            })
            Toast.fire({
                icon: 'error',
                title: 'Erro ao Atualizar Usuário!'
            })</script>";
            break;
        case "adicionado":
            echo "<script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 2000,
            })
            Toast.fire({
                icon: 'success',
                title: 'Usuário Adicionado com Sucesso!'
            })</script>";
            break;
        case "excluido":
            echo "<script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 2000,
            })
            Toast.fire({
                icon: 'success',
                title: 'Usuário Excluído com Sucesso!'
            })</script>";
            break;
        case "all_excluido":
            echo "<script>
            const Toast = Swal.mixin({
                toast: true,
                position: 'bottom',
                showConfirmButton: false,
                timer: 2000,
            })
            Toast.fire({
                icon: 'success',
                title: 'Usuários Excluídos com Sucesso!'
            })</script>";
            break;
            
    }
}
?>

<?php include './includes/footer.php'; ?>