<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Buscar Clientes</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Estilos personalizados -->
    <style>
         body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      padding: 20px;
      background: linear-gradient(to right, #0f2027, #203a43, #2c5364);
      color: #f0f0f0;
      min-height: 100vh;
    }
    .card {
      max-width: 1000px;
      margin: auto;
      background: #1e1e2f;
      padding: 30px 25px;
      border-radius: 14px;
      box-shadow: 0 15px 40px rgba(0, 0, 0, 0.4);
    }
        
        .card-header {
           
            color: white;
            border-radius: 10px 10px 0 0 !important;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
        }
        
        .btn-primary:hover {
            background: linear-gradient(135deg, #5a6fd1 0%, #6a4299 100%);
        }
        
        .table th {
            background-color: #f8f9fa;
            color: #495057;
        }
        
        .badge-success {
            background-color: #28a745;
        }
        
        .badge-warning {
            background-color: #ffc107;
            color: #212529;
        }
        
        .badge-danger {
            background-color: #dc3545;
        }
        
        .mac-input {
            text-transform: uppercase;
        }
        
        .whatsapp-reminder {
            background-color: #25D366;
            color: white;
        }
        
        .whatsapp-reminder:hover {
            background-color: #1da851;
            color: white;
        }
        
        .protection-btn {
            min-width: 110px;
        }
        
        .btn-warning {
            background-color: #ffc107;
            color: #212529;
        }
        
        .btn-warning:hover {
            background-color: #e0a800;
            color: #212529;
        }
        .modal-content {
         max-width: 600px;
      margin: auto;
      background: #1e1e2f;
      padding: 30px 25px;
      border-radius: 14px;
      box-shadow: 0 15px 40px rgba(0, 0, 0, 0.4);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="card-header text-center">
                <h3><i class="fas fa-users"></i> Gestión de Clientes</h3>
                <h5></i>Aquí puedes generar códigos para clientes nuevos o buscar tus clientes actuales para Renovación o Edición.</h5>
                <a href="generar_publico.php" class="btn btn-success">
                                <i class="fas fa-key"></i> Generar Código
                            </a>
            </div>
            <div class="card-body">
                <!-- Mensajes de estado -->
                <div id="message-container"></div>
                
                <!-- Formulario de búsqueda -->
                <form id="search-form" class="mb-4">
                    <div class="input-group">
                        <input type="text" id="search-input" name="search" class="form-control" 
                               placeholder="Buscar MAC" required>
                        <div class="input-group-append">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-search"></i> Buscar
                            </button>
                            
                        </div>
                    </div>
                </form>
                
                <!-- Resultados de búsqueda -->
                <div id="search-results"></div>
            </div>
        </div>
    </div>
    
    <!-- Modal de edición -->
   <div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content"> <!-- IMPORTANTE: modal-content -->
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title"><i class="fas fa-user-edit"></i> Editar Cliente</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form id="edit-form">
        <div class="modal-body" id="edit-modal-body">
          <!-- Aquí va el formulario dinámico -->
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">
            <i class="fas fa-times"></i> Cancelar
          </button>
          <button type="submit" class="btn btn-primary">
            <i class="fas fa-save"></i> Guardar Cambios
          </button>
        </div>
      </form>
    </div>
  </div>
</div>
    <!-- Modal de confirmación -->
    <div class="modal fade" id="confirmModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title"><i class="fas fa-exclamation-triangle"></i> Confirmar Eliminación</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body text-white">
                    ¿Está seguro que desea eliminar este cliente?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">
                        <i class="fas fa-times"></i> Cancelar
                    </button>
                    <button type="button" id="confirm-delete-btn" class="btn btn-danger">
                        <i class="fas fa-trash-alt"></i> Eliminar
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS y dependencias -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <!-- Script de la aplicación -->
    <script src="js/buscar_clientes.js"></script>
<script>
$(document).ready(function () {
    $('#search-input').on('input', function () {
        let value = $(this).val().replace(/[^A-Fa-f0-9]/g, '').toUpperCase(); // Solo hex y en mayúsculas

        // Insertar ":" cada dos caracteres
        let formatted = '';
        for (let i = 0; i < value.length && i < 12; i += 2) {
            if (i > 0) formatted += ':';
            formatted += value.substr(i, 2);
        }

        $(this).val(formatted);
    });
});
</script>
</body>
</html>