<?php
// Ruta al archivo JSON de configuración dentro de la carpeta api
$configFile = __DIR__ . '/config_sport.json';

// Valores por defecto en caso de que no exista el archivo
$defaultConfig = [
    'url' => 'https://sys.rgvip.xyz/rgvip_sport.php',
    'scroll_speed' => 3000,
    'scroll_amount' => -10
];

// Leer configuración desde el archivo JSON o usar los valores por defecto
$config = file_exists($configFile)
    ? json_decode(file_get_contents($configFile), true)
    : $defaultConfig;

// Extraer los valores
$websiteUrl = $config['url'];
$scrollSpeed = (int)$config['scroll_speed'];
$scrollAmount = (int)$config['scroll_amount'];

// HTML con WebView y scroll configurado dinámicamente
$htmlContent = <<<HTML
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>WebView</title>
    <style>
        body {
            margin: 0;
            overflow: hidden;
        }
        iframe {
            width: 100%;
            height: 100vh;
            border: none;
        }
    </style>
</head>
<body>
    <iframe id="webview" src="$websiteUrl" frameborder="0" allowfullscreen></iframe>
    <script>
        document.getElementById('webview').onload = function() {
            setInterval(function() {
                window.scrollBy(0, $scrollAmount);
            }, $scrollSpeed);
        };
    </script>
</body>
</html>
HTML;

// Enviar como contenido HTML
header("Content-Type: text/html");
echo $htmlContent;
