<?php include('includes/header.php'); ?>
<?php
ob_start(); // Inicia el buffer de salida
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Función para registrar logs en un archivo
function logMessage($message) {
    $logFile = "log.txt";
    $timestamp = date("Y-m-d H:i:s");
    file_put_contents($logFile, "[$timestamp] $message" . PHP_EOL, FILE_APPEND);
}

// Función para remover todos los archivos de la pasta
function clearDirectory($dir) {
    $files = glob($dir . '*');
    foreach ($files as $file) {
        if (is_file($file)) {
            unlink($file); // Deleta o arquivo
        }
    }
}

// Processamento do backend
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    logMessage("Requisição POST recebida.");

    // Verificar e criar o diretório de upload
    $targetDir = "splashscreen/";
    if (!is_dir($targetDir)) {
        if (mkdir($targetDir, 0777, true)) {
            logMessage("Diretório '$targetDir' criado com sucesso.");
        } else {
            logMessage("Erro ao criar o diretório '$targetDir'.");
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Erro ao criar o diretório."]);
            exit;
        }
    }

    // Limpar a pasta de upload
    clearDirectory($targetDir);

    // Nome do arquivo para armazenar o registro
    $urlFile = $targetDir . "splashscreen.txt";

    // Limpar o arquivo splashscreen.txt antes de escrever
    if (file_put_contents($urlFile, '') === false) {
        logMessage("Erro ao limpar o arquivo '$urlFile'.");
        http_response_code(500);
        echo json_encode(["status" => "error", "message" => "Erro ao limpar o arquivo splashscreen.txt."]);
        exit;
    } else {
        logMessage("Arquivo '$urlFile' limpo com sucesso.");
    }

    // Processar upload do arquivo de vídeo
    if (isset($_FILES['video'])) {
        logMessage("Arquivo de vídeo detectado no POST.");

        // Gera um nome único para o arquivo, mantendo a extensão original
        $fileExtension = pathinfo($_FILES['video']['name'], PATHINFO_EXTENSION);
        $newFileName = uniqid('video_', true) . '.' . $fileExtension; // Exemplo: video_64b5f7eaed9b9.12345.mp4
        $targetFilePath = $targetDir . $newFileName;

        // Mover o arquivo para o destino com o novo nome
        if (move_uploaded_file($_FILES['video']['tmp_name'], $targetFilePath)) {
            logMessage("Arquivo salvo com o nome: $newFileName em: $targetFilePath");

            // Detectar o protocolo (http ou https)
            $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";

            // Obter o domínio atual
            $domain = $_SERVER['HTTP_HOST'];

            // Detectar o diretório base até a pasta splashscreen
            $basePath = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/'); // Caminho até o diretório donde o script está

            // Criar a URL completa até a pasta splashscreen
            $fileUrl = $protocol . $domain . $basePath . "/splashscreen/" . $newFileName;

            // Salvar o caminho no arquivo splashscreen.txt
            if (file_put_contents($urlFile, $fileUrl . PHP_EOL, FILE_APPEND)) {
                logMessage("Caminho salvo em '$urlFile': $fileUrl");
                echo json_encode(["status" => "success", "message" => "Arquivo salvo com sucesso em: " . $fileUrl]);
            } else {
                logMessage("Erro ao salvar o caminho no arquivo splashscreen.txt.");
                http_response_code(500);
                echo json_encode(["status" => "error", "message" => "Erro ao salvar o caminho no splashscreen.txt."]);
            }
        } else {
            logMessage("Erro ao salvar o arquivo de vídeo.");
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Erro ao salvar o arquivo."]);
        }
        exit;
    }

    // Processar URL enviada
    elseif (isset($_POST['url'])) {
        logMessage("URL detectada no POST.");

        $videoUrl = $_POST['url'];
        if (file_put_contents($urlFile, $videoUrl . PHP_EOL, FILE_APPEND)) {
            logMessage("URL salva em '$urlFile': $videoUrl");
            echo json_encode(["status" => "success", "message" => "URL salva com sucesso: " . $videoUrl]);
        } else {
            logMessage("Erro ao salvar a URL no arquivo splashscreen.txt.");
            http_response_code(500);
            echo json_encode(["status" => "error", "message" => "Erro ao salvar a URL no splashscreen.txt."]);
        }
        exit;
    }

    // Nenhum dado válido enviado
    else {
        logMessage("Nenhum dado válido enviado no POST.");
        http_response_code(400);
        echo json_encode(["status" => "error", "message" => "Nenhum dado enviado."]);
        exit;
    }
} else {
    // Se não for uma requisição POST, apenas continue
}
ob_end_flush(); // Envía el buffer y lo limpia
?>
<head>
     <link rel="stylesheet" type="text/css" href="css/styles1.css">
</head>
</head>
<body>
    <div class="container mt-5">
        <div class="col-md-8 mx-auto">
            <div class="card">
                <div class="card-header bg-primary text-white text-center">
                    <h2>Video Intro</h2>
                </div>
                <div id="upload" class="upload-zone">
                    <p>¡PRECIONA AQUI para subir tu video intro!</p>
                    <span>Recomendación: Subir video intro liviano formato .mp4 no mayor a 10 segundos</span>
                </div>
                <div class="separator">&mdash; AQUI ABAJO PUEDES HACERLO MEDIANTE LINK &mdash;</div>
                <div class="input-wrap">
                 <input id="url" type="text" class="paste-url" placeholder="Pega el link del vídeo intro aqui...">
                    <button id="confirmButton" class="confirm-button">Confirmar Envío</button>
                    <div class="load">
                        <div class="loader-item loader-1"></div>
                    </div>
                </div>
                <div class="progress-bar-container">
                    <div class="progress-bar" style="width: 0%;">0%</div>
                </div>
                <div id="video-popup" class="video-popup">
                    <div class="video-popup-content">
                        <button id="close-popup" class="close-popup">X</button>
                        <h2>Ver Video Actual</h2>
                        <div id="video-container"></div>
                    </div>
                </div>
                <button id="showVideoButton" class="show-video-button">Ver Video Actual</button>
            </div>
        </div>
    </div>

    <!-- Modal de éxito con icono de check -->
<div id="successModal" class="modal">
    <div class="modal-content">
        <div class="modal-icon">
            <!-- Aquí va el icono de check -->
            <span>&#10003;</span> <!-- Icono de check (puedes reemplazar con cualquier otro) -->
        </div>
        <p>¡Video subido con éxito!</p>
        <span class="close-modal">×</span> <!-- Botón para cerrar el modal -->
    </div>
</div>
    <script>
        // Elementos del DOM
        const showVideoButton = document.getElementById('showVideoButton');
        const videoPopup = document.getElementById('video-popup');
        const videoContainer = document.getElementById('video-container');
        const closePopupButton = document.getElementById('close-popup');
        const progressBar = document.querySelector('.progress-bar');
        const progressBarContainer = document.querySelector('.progress-bar-container');
        const videoArea = document.getElementById('upload');
        const fileInput = document.createElement('input');
        const confirmButton = document.getElementById('confirmButton');
        const urlInput = document.getElementById('url');
        const loadingIndicator = document.querySelector('.load');
        const successModal = document.getElementById('successModal');
        const closeModalButton = document.querySelector('.close-modal');

        let videoSource = null; // Fuente del video
        let isFile = false; // Indicador de si es un archivo

        // Mostrar el popup de video
        showVideoButton.addEventListener('click', () => {
            fetch('splashscreen/splashscreen.txt')
                .then(response => response.text())
                .then(data => {
                    const videoUrl = data.trim();
                    if (videoUrl) {
                        const videoElement = document.createElement('video');
                        videoElement.src = videoUrl + '?t=' + new Date().getTime(); // Evitar caché
                        videoElement.controls = true;
                        videoContainer.textContent = '';
                        videoContainer.appendChild(videoElement);
                        videoPopup.style.display = 'flex';
                    } else {
                        alert('No hay un video actual para mostrar.');
                    }
                })
                .catch(error => {
                    console.error('Error al cargar el video:', error);
                    alert('Error al cargar el video.');
                });
        });

      closePopupButton.addEventListener('click', () => {
    // Buscar el video dentro del popup
    const videoElement = videoContainer.querySelector('video');
    
    if (videoElement) {
        videoElement.pause();  // Pausa el video
        videoElement.currentTime = 0;  // Opcional: resetea el video al inicio
    }

    // Ocultar el popup
    videoPopup.style.display = 'none';
});

        // Configurar el input de archivo
        fileInput.type = 'file';
        fileInput.accept = 'video/*';
        fileInput.style.display = 'none';
        document.body.appendChild(fileInput);

        // Mostrar el input de archivo al hacer clic en el área de carga
        videoArea.addEventListener('click', () => fileInput.click());

        // Manejar la selección de archivo
        fileInput.addEventListener('change', (event) => {
            const file = event.target.files[0];
            if (file && file.type.startsWith('video/')) {
                displayVideo(file);
                isFile = true;
                videoSource = file;
                showConfirmButton();
            } else {
                alert("El archivo seleccionado no es un video.");
            }
        });

        // Mostrar el botón de confirmación
        function showConfirmButton() {
            confirmButton.style.display = 'block';
        }

        // Mostrar el video en el área de carga
        function displayVideo(source) {
            const video = document.createElement('video');
            video.controls = true;
            video.src = source instanceof File ? URL.createObjectURL(source) : source;
            videoArea.textContent = '';
            videoArea.appendChild(video);
        }

        // Mostrar el modal de éxito
        function showSuccessModal() {
            successModal.style.display = 'flex';
        }

        // Ocultar el modal de éxito
        closeModalButton.addEventListener('click', () => {
            successModal.style.display = 'none';
        });

        // Cerrar el modal si se hace clic fuera del contenido
        window.addEventListener('click', (event) => {
            if (event.target === successModal) {
                successModal.style.display = 'none';
            }
        });

        // Manejar la subida del archivo o URL
        confirmButton.addEventListener('click', () => {
            const formData = new FormData();
            if (isFile && videoSource instanceof File) {
                formData.append('video', videoSource);
            } else if (!isFile && typeof videoSource === 'string') {
                formData.append('url', videoSource);
            } else {
                alert('No se ha seleccionado un video o una URL válida.');
                return;
            }

            const xhr = new XMLHttpRequest();
            xhr.open('POST', '', true);

            // Mostrar la barra de progreso
            progressBarContainer.style.display = 'block';
            progressBar.style.width = '0%';
            progressBar.textContent = '0%';

            // Actualizar la barra de progreso durante la subida
            xhr.upload.addEventListener('progress', (event) => {
                if (event.lengthComputable) {
                    const percent = (event.loaded / event.total) * 100;
                    progressBar.style.width = `${percent}%`;
                    progressBar.textContent = `${Math.round(percent)}%`;
                }
            });

           xhr.onload = () => {
    if (xhr.status === 200) {
        // Muestra el mensaje de éxito (con el icono de check) directamente
        showSuccessModal(); // Mostrar el modal de éxito con el icono de check
    } else {
        alert('Error al enviar.');
    }
    // Ocultar la barra de progreso después de la subida
    progressBarContainer.style.display = 'none';
            };

            // Manejar errores
            xhr.onerror = () => {
                alert('Error en la conexión.');
                progressBarContainer.style.display = 'none';
            };

            xhr.send(formData);
        });

        // Manejar la entrada de URL
        urlInput.addEventListener('input', () => {
            const url = urlInput.value.trim();
            if (url) {
                isFile = false;
                videoSource = url;
                showConfirmButton();
            }
        });
    </script>
</body>
<?php include('includes/footer.php'); ?>