<?php
// processar_permissoes.php

// Conectar ao banco de dados SQLite (ele será criado se não existir)
$db = new SQLite3('permissoes.db');
$db->busyTimeout(5000); // 5000 ms = 5 segundos

// Criar a tabela se não existir
$db->exec("CREATE TABLE IF NOT EXISTS permissoes (
    mac_address VARCHAR(20) PRIMARY KEY,
    permissao TEXT
)");

// Verifica se a requisição é POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Recebe os dados em formato JSON
    $data = json_decode(file_get_contents("php://input"));

    // Verifica se o MAC e as permissões foram passados corretamente
    if (isset($data->mac_address) && isset($data->permissoes) && is_array($data->permissoes)) {
        $mac_address = strtoupper($data->mac_address); // Convertendo o MAC para maiúsculas
        $permissoes = implode(',', $data->permissoes); // Concatena as permissões em uma string separada por vírgulas

        // Preparar a consulta para inserir ou atualizar as permissões no banco
        $stmt = $db->prepare("INSERT OR REPLACE INTO permissoes (mac_address, permissao) VALUES (:mac_address, :permissao)");
        $stmt->bindValue(':mac_address', $mac_address, SQLITE3_TEXT);
        $stmt->bindValue(':permissao', $permissoes, SQLITE3_TEXT);
        $stmt->execute();

        // Consulta a linha atualizada ou inserida
        $stmt = $db->prepare("SELECT * FROM permissoes WHERE mac_address = :mac_address");
        $stmt->bindValue(':mac_address', $mac_address, SQLITE3_TEXT);
        $result = $stmt->execute();
        $row = $result->fetchArray(SQLITE3_ASSOC);

        // Resposta com os dados da linha
        echo json_encode([
            'mensagem' => 'Permissões enviadas com sucesso!',
            'linha' => $row
        ]);
    } else {
        echo json_encode([
            'erro' => 'Dados inválidos. MAC Address e permissões são obrigatórios.'
        ]);
    }
} else {
    echo json_encode([
        'erro' => 'Método de requisição inválido. Use POST.'
    ]);
}

// Fechar a conexão com o banco
$db->close();
?>
