<?php
// Inclui funções e inicia a sessão
include "includes/functions.php";

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

$error = ""; // Variável para armazenar mensagens de erro

// Verifica se o usuário está logado
$log_check = $db->select("users", "*", "id = :id", "", [":id" => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]["username"] : NULL;

if (!empty($loggedinuser) && isset($_SESSION["name"]) && $_SESSION["name"] === $loggedinuser) {
    header("Location: dns.php");
    exit;
}

// Insere o usuário admin se não existir
$data = ["id" => "1", "username" => "admin", "password" => "admin"];
$db->insertIfEmpty("users", $data);

// Processa o login
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["login"])) {
    $username = trim($_POST["username"]);
    $password = trim($_POST["password"]);
    $userData = $db->select("users", "*", "username = :username", "", [":username" => $username]);

    if ($userData) {
        $storedPassword = $userData[0]["password"];
        if ($password === $storedPassword) {
            session_regenerate_id(true);
            $_SESSION["loggedin"] = true;
            $_SESSION["name"] = $username;
            header("Location: dns.php");
            exit;
        } else {
            $error = "❌Senha incorreta. Tente novamente.";
        }
    } else {
        $error = "Usuário não encontrado.";
    }
}

// Variáveis para descrição e links
$descriptionText1 = <<<HTML
<span style="color: white; font-size: 16px;">
    Mod do Painel e Aplicativo idealizado por<br> 
    <span style="color: red; font-size: 20px; text-decoration: underline;"></span><br>
    e equipe<br>
    <span style="color: red; font-size: 20px; text-decoration: underline;">IBO PLAYER PRO</span>
</span>
HTML;

$descriptionLink = ""; // Adicione o link desejado aqui
$descriptionLinkText = <<<HTML
<a href="$descriptionLink" target="_blank" style="color: blue; text-decoration: underline;">
    Clique aqui para suporte
</a>
HTML;

$descriptionText2 = <<<HTML
<span style="color: white; font-size: 16px;">
    Este é o segundo campo de descrição. Você pode copiar este texto.
</span>
HTML;

$file_name = './codigo_json.json';
$json_data = file_get_contents($file_name);

if ($json_data === false) {
    die("Erro ao ler o arquivo JSON.");
}

// 2. Converter a String JSON para um Array PHP
$data = json_decode($json_data, true); // Passar true para obter um array associativo

$codigo = $data['codigo'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="author" content="IBO PLAYER PRO">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css">
    <title>Panel ibo RGVIP</title>
    <meta content=".img/logo.png" property="og:image"/>
    <style>
        body {
            background-color: #181828;
            background-image: url("./assets/images/default_background.jpg");
            color: #fff;
        }

        #particles-js {
            background-size: cover;
            background-position: 50% 50%;
            background-repeat: no-repeat;
            background: #8000FF;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .particles-js-canvas-el {
            position: fixed;
        }

        .login-form {
            background-color: rgba(0, 0, 0, 0.7); /* Cor de fundo com transparência */
            border-radius: 20px;
            padding: 20px;
            box-shadow: 0px 0px 20px rgba(255, 255, 255, 0.2);
            border-top: 5px solid #0A38D1;
        }

        .login-form img {
            width: 75%;
            margin: 0 auto;
            display: block;
            margin-bottom: 20px;
        }

        .login-form input[type="text"],
        .login-form input[type="password"] {
            background-color: #333;
            color: #fff;
        }

        .login-form input[type="submit"] {
            background-color: #0A38D1;
            border: none;
        }

        .login-form input[type="submit"]:hover {
            background-color: #0529a3;
        }

        .error-message {
            color: red;
            margin-top: 10px;
            font-size: 14px;
        }
    </style>
</head>
<body>
<div id="js-particles"></div>
<br><br>
<div class="container">
    <div class="row">
        <div class="col-lg-4 mx-md-auto">
            <form method="post" class="login-form">
                <img src="<?php
                if (empty($rowk['path'])) {
                    echo 'img/logo.png?t=' . time();
                } else {
                    echo $rowk['path'];
                } ?>" alt="">

                <?php if (!empty($error)): ?>
                    <div class="error-message"><?php echo $error; ?></div>
                <?php endif; ?>

                <div class="form-group">
                    <input type="text" class="form-control form-control-lg"
                           placeholder="Usuario" name="username" required autofocus>
                </div>
                <div class="form-group">
                    <input type="password" class="form-control form-control-lg"
                           placeholder="Contraseña" name="password" required>
                </div>
                
                <!-- Botão de Entrar -->
<input type="submit" class="btn btn-primary btn-lg btn-block" value="Entrar" name="login">

<!-- Link "Esqueceu a senha?" -->
<div class="text-center">
    <a href="admin_access.php" class="text-muted">Recuperar Contraseña</a>
</div>

<!-- IBO PLAYER PRO Centralizado sem fundo branco -->
<div class="text-center" style="margin-top: 20px;">
    <a href="https://apps-rgvip.com" target="_blank" style="text-decoration: none;">&#169; Rgvip Panels</a>
</div>

                
            </form>

        </div>
    </div>
</div>
<br><br>

<script src="https://code.jquery.com/jquery-3.3.1.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js"
        integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49"
        crossorigin="anonymous"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js"
        integrity="sha384-ChfqqxuZUCnJSK3+MXmPNIyE6ZbWh2IMqE241rYiqJxyMiZ6OW/JmZQ5stwEULTy"
        crossorigin="anonymous"></script>
</body>
</html>
