<?php
// Configuración de la API de TMDB
$api_key = '6b8e3eaa1a03ebb45642e9531d8a76d2'; // Reemplaza 'TU_API_KEY' con tu clave API de TMDB.
$base_url = 'https://api.themoviedb.org/3';
$endpoint = '/movie/popular'; // Endpoint para películas populares
$language = 'es-MX'; // Idioma de los resultados

// Obtener películas populares
$movie_url = $base_url . '/movie/popular?api_key=' . $api_key . '&language=' . $language;
$movie_response = file_get_contents($movie_url);
if ($movie_response === FALSE) {
    die('Error al conectar con la API de TMDB.');
}
$movies = json_decode($movie_response, true)['results'];

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Anuncios Dinámicos TMDB</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            background-color: #000;
            color: white;
            text-align: center;
        }
        .background {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-size: cover;
            background-position: center;
            z-index: -1;
            filter: brightness(0.5);
        }
        .container {
            position: absolute;
            top: 50%;
            left: 55%;
            width: 500px; /* Tamaño fijo del contenedor */
            height: 300px; /* Tamaño fijo del contenedor */
            transform: translate(-50%, -50%);
            background-color: rgba(0, 0, 0, 0.3);
            padding: 10px;
            border-radius: 15px;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.5);
            overflow: hidden; /* Evita que el contenido se salga del contenedor */
        }
        h1 {
            font-size: 1.5em;
            margin-bottom: 10px;
            white-space: nowrap; /* Evita que el título se divida en varias líneas */
            overflow: hidden;
            text-overflow: ellipsis; /* Añade puntos suspensivos si el texto es demasiado largo */
        }
        .rating {
            margin: 10px 0;
        }
        .rating span {
            font-size: 1.2em;
            color: gold;
        }
        p {
            font-size: 1em;
            margin-bottom: 20px;
            overflow: hidden;
            text-overflow: ellipsis;
            display: -webkit-box;
            -webkit-line-clamp: 3; /* Limita el texto a 3 líneas */
            -webkit-box-orient: vertical;
        }
        .cast {
            display: flex;
            justify-content: center;
            flex-wrap: wrap;
            gap: 10px;
        }
        .cast-member {
            text-align: center;
            width: 80px; /* Tamaño fijo para cada miembro del elenco */
        }
        .cast-member img {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            border: 2px solid white;
        }
        .cast-member span {
            display: block;
            margin-top: 5px;
            font-size: 0.8em;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
    </style>
</head>
<body>
    <div id="background" class="background"></div>
    <div class="container">
        <h1 id="title">Cargando...</h1>
        <div id="rating" class="rating"></div>
        <p id="overview">Por favor, espera mientras cargamos el anuncio.</p>
        <div class="cast" id="cast"></div>
    </div>

    <script>
        const movies = <?php echo json_encode($movies); ?>;
        const apiKey = "<?php echo $api_key; ?>";
        const baseUrl = "https://api.themoviedb.org/3";
        let currentIndex = 0;

        async function fetchCast(movieId) {
            const response = await fetch(`${baseUrl}/movie/${movieId}/credits?api_key=${apiKey}`);
            const data = await response.json();
            return data.cast.slice(0, 4); // Obtener máximo 4 personajes principales
        }

        async function updateAd() {
            const movie = movies[currentIndex];
            const background = document.getElementById('background');
            const title = document.getElementById('title');
            const overview = document.getElementById('overview');
            const rating = document.getElementById('rating');
            const cast = document.getElementById('cast');

            // Actualizar contenido principal
            background.style.backgroundImage = `url('https://image.tmdb.org/t/p/original${movie.backdrop_path}')`;
            title.textContent = movie.title;
            overview.textContent = movie.overview;

            // Mostrar estrellas para el puntaje
            const starRating = Math.round(movie.vote_average / 2); // Escala de 5 estrellas
            rating.innerHTML = '★'.repeat(starRating) + '☆'.repeat(5 - starRating);

            // Obtener y mostrar personajes principales
            const castData = await fetchCast(movie.id);
            cast.innerHTML = '';
            castData.forEach(member => {
                const div = document.createElement('div');
                div.classList.add('cast-member');
                div.innerHTML = `
                    <img src="https://image.tmdb.org/t/p/w500${member.profile_path}" alt="${member.name}" onerror="this.src='https://via.placeholder.com/60'">
                    <span>${member.name}</span>
                `;
                cast.appendChild(div);
            });

            // Cambiar al siguiente anuncio
            currentIndex = (currentIndex + 1) % movies.length;
        }

        // Actualizar anuncio cada 8 segundos
        setInterval(updateAd, 8000);

        // Mostrar el primer anuncio de inmediato
        updateAd();
    </script>
</body>
</html>