<?php
include "includes/header.php";
?>
<style>
  .custom-button {
    padding: 10px 20px;
  }
  
  /* Estrutura de layout para sidebar e conteúdo */
  .page-container {
    display: flex;
    transition: all 0.3s ease;
  }
  /* O sidebar (menu) já deve estar definido no header, mas aqui definimos a largura */
  .page-sidebar {
    width: 250px;
    transition: width 0.3s ease;
  }
  /* Quando o menu for colapsado, a largura é reduzida */
  .page-container.sidebar-collapsed .page-sidebar {
    width: 80px;
  }
  /* Área do conteúdo: não será empurrada com margem fixa, mas se adaptará ao espaço restante */
  .page-content {
    flex: 1;
    transition: all 0.3s ease;
    padding: 20px; /* Espaçamento interno para não encostar na lateral */
  }
  /* Container interno para centralizar e limitar a largura do conteúdo */
  .content-wrapper {
    max-width: 1200px;
    margin: 0 auto;
    padding: 15px;
  }
  
  /* Responsividade: ajuste da largura do vídeo para telas menores */
  .preview-video {
    width: 100%;
    height: auto;
  }
</style>

<!-- Estrutura da página: o header (que inclui o sidebar) já deve estar definido em includes/header.php -->
<div class="page-container" id="page-container">
  <!-- O menu (sidebar) é carregado via header.php -->
  
  <!-- Conteúdo principal -->
  <div class="page-content">
    <div class="content-wrapper">
      <div class="container">
        <!-- Page Heading -->
        <h1 class="h3 mb-1 text-gray-800">Video Background</h1>
        <!-- Card de opções -->
        <div class="card border-left-primary shadow h-100 card shadow mb-4">
          <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary"><i class="fa fa-cogs"></i> Choose</h6>
          </div>
          <div class="card-body">
            <?php
            $jsonFilex = './a/rtx/video_filenames.json';
            // Lê e decodifica o arquivo JSON
            $jsonDatax = file_get_contents($jsonFilex);
            $imageDatax = json_decode($jsonDatax, true);
            // Extrai o nome do arquivo do vídeo
            $filenamex = $imageDatax[0]['ImageName'];
            $videoFilex = "./rtx/video/" . $filenamex;
            
            echo '<h3>Currently in use:</h3>';
            echo '<video class="preview-video" controls>';
            echo '<source src="' . $videoFilex . '" type="video/mp4">';
            echo 'Your browser does not support the video tag.';
            echo '</video>';
            
            // Processamento do upload do vídeo
            if (isset($_POST['upload'])) {
                // Exemplo de arquivos que não devem ser removidos (ajuste conforme necessário)
                $selectedFiles = ['logo.png', 'index.php', 'iimg.json', 'filenames.json', 'binding_dark.webp', 'bg.jpg', 'api.php', 'favicon.ico', 'logo_ne.png', '.htaccess'];
                $folderPath = './rtx/video/';
                $files = scandir($folderPath);
                foreach ($files as $file) {
                    if ($file !== '.' && $file !== '..') {
                        $filePath = $folderPath . $file;
                        if (!in_array($file, $selectedFiles)) {
                            unlink($filePath);
                        }
                    }
                }
                
                if (isset($_FILES['video'])) {
                    $file = $_FILES['video'];
                    $fileType = $file['type'];
                    $fileTemp = $file['tmp_name'];
                    
                    // Tipos permitidos
                    $allowedTypes = ['video/mp4', 'video/webm'];
                    if (in_array($fileType, $allowedTypes)) {
                        $uploadPath = './rtx/video/';
                        $fileName = uniqid() . '.' . pathinfo($file['name'], PATHINFO_EXTENSION);
                        $destination = $uploadPath . $fileName;
                        
                        if (move_uploaded_file($fileTemp, $destination)) {
                            echo "<script>window.location.href='mRTXBGVideo.php';</script>";
                            
                            $jsonFilePath = './a/rtx/video_filenames.json';
                            $jsonData = json_encode([["ImageName" => $fileName]]);
                            file_put_contents($jsonFilePath, $jsonData);
                        } else {
                            echo 'Failed to move the uploaded file.';
                        }
                    } else {
                        echo 'Invalid file type. Only MP4 and WebM videos are allowed.';
                    }
                }
            }
            ?>
            
            <form method="post" enctype="multipart/form-data">
              <label for="video">Select a Video to upload:</label>
              <input type="file" name="video" id="video" accept="video/mp4, video/webm">
              <button type="submit" class="custom-button btn btn-success btn-icon-split" name="upload">Upload</button>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Exemplo de script para alternar o menu responsivamente -->
<script>
  // Supondo que exista um botão com id "toggle-menu" para abrir/fechar o sidebar
  document.getElementById('toggle-menu')?.addEventListener('click', function(e) {
    e.preventDefault();
    document.getElementById('page-container').classList.toggle('sidebar-collapsed');
  });
</script>

<?php
include "includes/footer.php";
?>
</body>
</html>
