<?php
// Caminho para o arquivo JSON e diretório de vídeos
$jsonFilePath = '../a/rtx/video_filenames.json';
$videoDirPath = '../rtx/video/';

// Configurar cabeçalhos para o aplicativo
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Função para enviar respostas JSON (em caso de erro ou sucesso)
function sendResponse($status, $message, $data = null) {
    header('Content-Type: application/json');
    echo json_encode(['status' => $status, 'message' => $message, 'data' => $data]);
    exit;
}

// Verificar o método da requisição
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'OPTIONS') {
    // Tratamento para requisições preflight
    exit;
}

// Requisição GET para ler e enviar o vídeo
if ($method === 'GET') {
    if (!file_exists($jsonFilePath)) {
        sendResponse('error', 'JSON file not found.');
    }

    // Ler o nome do arquivo de vídeo do JSON
    $jsonData = file_get_contents($jsonFilePath);
    $decodedData = json_decode($jsonData, true);
    $videoFileName = $decodedData[0]['ImageName'] ?? null;

    if (!$videoFileName) {
        sendResponse('error', 'Video file name not found in JSON.');
    }

    $videoFilePath = $videoDirPath . $videoFileName;

    if (!file_exists($videoFilePath)) {
        sendResponse('error', 'Video file not found on server.');
    }

    // Enviar o arquivo de vídeo como resposta
    header('Content-Type: video/mp4');
    header('Content-Length: ' . filesize($videoFilePath));
    readfile($videoFilePath);
    exit;
}

// Requisição POST para atualizar o arquivo JSON com um novo vídeo
if ($method === 'POST') {
    $inputData = file_get_contents('php://input');
    $decodedInput = json_decode($inputData, true);

    if (isset($decodedInput['ImageName'])) {
        $newData = [['ImageName' => $decodedInput['ImageName']]];
        file_put_contents($jsonFilePath, json_encode($newData));
        sendResponse('success', 'File updated successfully.');
    } else {
        sendResponse('error', 'Invalid input data.');
    }
}

// Caso o método seja inválido
sendResponse('error', 'Invalid request method.');
?>
