<?php
// Inclui o arquivo de cabeçalho (header) localizado no diretório 'includes'
require_once __DIR__ . '/includes/header.php';

// Inicializa variáveis para mensagens de erro e sucesso
$error = null; // Armazena mensagens de erro
$ok = null; // Armazena mensagens de sucesso

// Verifica se a requisição é do tipo POST (formulário enviado)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Requer a proteção contra ataques CSRF (Cross-Site Request Forgery)
    require_csrf();

    // Obtém e sanitiza os dados enviados pelo formulário
    $new_user = trim((string)($_POST['username'] ?? '')); // Novo nome de usuário
    $new_pass = (string)($_POST['password'] ?? ''); // Nova senha
    $new_pass2 = (string)($_POST['password2'] ?? ''); // Confirmação da nova senha

    // Validações dos campos do formulário
    if ($new_user === '' || $new_pass === '' || $new_pass2 === '') {
        $error = 'Todos os campos são obrigatórios.';
    } elseif ($new_pass !== $new_pass2) {
        $error = 'As senhas não coincidem.';
    } elseif (strlen($new_pass) < 8) {
        $error = 'A senha deve ter pelo menos 8 caracteres.';
    } else {
        // Cria um hash seguro da nova senha usando o algoritmo BCRYPT
        $hash = password_hash($new_pass, PASSWORD_BCRYPT);

        try {
            // Atualiza os dados do usuário no banco de dados
            DB::exec('UPDATE users SET username=?, password_hash=?, must_change=0 WHERE id=?', [$new_user, $hash, (int)$user['id']]);
            $ok = 'Credenciais atualizadas com sucesso.';
        } catch (\PDOException $e) {
            // Em caso de erro na atualização, exibe a mensagem de erro
            $error = 'Falha ao atualizar: ' . $e->getMessage();
        }
    }
}
?>

<!-- Título da página de configurações -->
<h1 class="text-2xl font-bold mb-4">Configurações</h1>

<!-- Exibe mensagem de erro, se houver -->
<?php if ($error): ?>
<div class="alert alert-bad mb-4"><?php echo h($error); ?></div>
<?php endif; ?>

<!-- Exibe mensagem de sucesso, se houver -->
<?php if ($ok): ?>
<div class="alert alert-good mb-4"><?php echo h($ok); ?></div>
<?php endif; ?>

<!-- Formulário para atualizar nome de usuário e senha -->
<form method="post" class="surface p-4 max-w-2xl">
    <?php echo csrf_input(); ?> <!-- Campo de proteção CSRF -->
    <label>Novo nome de usuário</label>
    <input name="username" value="<?php echo h($user['username']); ?>" required>
    <label class="mt-2">Nova senha</label>
    <input name="password" type="password" required>
    <label class="mt-2">Confirmar nova senha</label>
    <input name="password2" type="password" required>
    <div class="mt-2"><button class="btn">Salvar</button></div>
</form>

<!-- Modal exibido se o usuário precisar alterar as credenciais padrão -->
<?php if ((int)($user['must_change'] ?? 0) === 1): ?>
<div class="modal-backdrop show" id="mustChange">
    <div class="modal">
        <header>
            <div>Ação necessária</div>
            <a href="#" data-modal-close="mustChange">×</a>
        </header>
        <div class="content">
            <div class="alert alert-info">Você deve alterar as credenciais de administrador padrão antes de continuar usando o painel.</div>
        </div>
        <footer>
            <span class="text-subtle text-sm">Defina uma senha forte e clique em salvar.</span>
        </footer>
    </div>
</div>
<?php endif; ?>

<!-- Inclui o arquivo de rodapé (footer) localizado no diretório 'includes' -->
<?php require_once __DIR__ . '/includes/footer.php'; ?>