<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include(__DIR__ . '/includes/header.php'); // Header incluido
$qr_code = $db->select('qr_code', '*', 'id = :id', '', [':id' => '1']);
$current_label = $qr_code[0]['name'] ?? '';
$success_message = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST["web_label"])) {
        $name = trim($_POST["web_label"]);

        // Guarda el texto con saltos de línea
        $data = ['name' => $name];
        $db->update('qr_code', $data, 'id = :id', [':id' => '1']);

        $success_message = "Texto guardado con éxito.";
        $current_label = $name;
    }
}
?>
<div class="col-md-8 mx-auto">
            <div class="card-body">
                <div class="card bg-dark text-white">
                    <div class="card-header card-header-warning">
                        <center>
            <h2 class="mb-9">Texto debajo del botón de Abrir Sitio Web</h2>
            <?php if (!empty($success_message)): ?>
    <div class="alert alert-success fade-message" role="alert">
        <?= htmlspecialchars($success_message) ?>
    </div>
<?php endif; ?>
            <div class="row mb-12">
                <div class="col-xl-12 mb-15 mb-xl-0 pe-5">
                    <form method="POST" action="">
                        <div class="form-group">
                            <label for="web_label">Texto:</label>
                            <textarea 
                                class="form-control" 
                                name="web_label" 
                                id="web_label" 
                                placeholder="Máximo 30 caracteres por línea"
                                rows="4"
                                maxlength="60"
                                wrap="hard"
                                oninput="enforceLineLength(this, 30)"
                            ><?= htmlspecialchars($current_label) ?></textarea>
                            <small class="form-text text-muted mt-2">Máximo 30 caracteres por línea, y maximo 2 lineas
                            .</small>
                        </div>
                        <div class="text-center mt-4">
                            <input 
                                type="submit" 
                                name="submit" 
                                value="Guardar" 
                                class="btn btn-primary btn-block">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function enforceLineLength(textarea, maxCharsPerLine) {
    const lines = textarea.value.split('\n');
    let adjusted = false;

    for (let i = 0; i < lines.length; i++) {
        if (lines[i].length > maxCharsPerLine) {
            const overflow = lines[i].slice(maxCharsPerLine);
            lines[i] = lines[i].slice(0, maxCharsPerLine);
            lines.splice(i + 1, 0, overflow);
            adjusted = true;
        }
    }

    if (adjusted) {
        textarea.value = lines.join('\n');
    }
}
</script>
<script>
setTimeout(function () {
    const alert = document.querySelector('.fade-message');
    if (alert) {
        alert.style.transition = "opacity 0.5s ease";
        alert.style.opacity = 0;
        setTimeout(() => alert.remove(), 500); // remueve del DOM
    }
}, 3000); // 3 segundos
</script>

<?php include 'includes/footer.php'; ?>

