<?php
include "includes/header.php";
?>
<style>
  .custom-button {
    padding: 10px 20px;
  }
  /* Estrutura de layout para sidebar e conteúdo */
  .page-container {
    display: flex;
    transition: all 0.3s ease;
  }
  /* O sidebar (menu) já deve estar definido no header, mas aqui definimos a largura */
  .page-sidebar {
    width: 250px;
    transition: width 0.3s ease;
  }
  /* Quando o menu for colapsado, a largura é reduzida */
  .page-container.sidebar-collapsed .page-sidebar {
    width: 80px;
  }
 
  /* Responsividade: ajuste da largura do vídeo para telas menores */
  .preview-video {
    width: 100%;
    height: auto;
  }
</style>
<div class="page-container" id="page-container">
        <div class="mx-auto px-3" style="max-width: 700px;">
          <div class="card border-left-primary shadow h-100 card shadow mb-4">
            <div class="card-header py-3">
              <h6 class="m-0 font-weight-bold text-secondary">
                <i class="fa fa-film"></i>Actualización de Video Intro
              </h6>
            </div>
            <div class="card-body">
              <?php
              $videoPath = 'splash_rgvip/intro.mp4';

              if (file_exists($videoPath)) {
                $timestamp = filemtime($videoPath); // Para evitar cache del navegador
                echo '<h3>Video Actual:</h3>';
                echo '<video class="preview-video" controls preload="auto" playsinline>';
                echo '<source src="' . $videoPath . '?v=' . $timestamp . '" type="video/mp4">';
                echo 'Tu navegador no soporta la etiqueta de video.';
                echo '</video>';
              } else {
                echo '<p>No hay un video cargado actualmente.</p>';
              }
              if (isset($_POST['upload']) && isset($_FILES['video'])) {
                $file = $_FILES['video'];
                $fileType = $file['type'];
                $fileTemp = $file['tmp_name'];
                $allowedTypes = ['video/mp4'];
                if (in_array($fileType, $allowedTypes)) {
                  $destination = 'splash_rgvip/intro.mp4';
                  if (move_uploaded_file($fileTemp, $destination)) {
                    clearstatcache(); // Limpiar cache de información del archivo
                    echo "<script>window.location.href=window.location.href;</script>";
                  } else {
                    echo '<div class="alert alert-danger mt-3">Error al mover el archivo.</div>';
                  }
                } else {
                  echo '<div class="alert alert-warning mt-3">Formato no permitido. Solo se permite MP4.</div>';
                }
              }
              ?>
              <form method="post" enctype="multipart/form-data" class="mt-4">
                <label for="video">Selecciona un video (.mp4):</label>
                <input type="file" name="video" id="video" accept="video/mp4" required class="form-control mb-2">
                <button type="submit" class="custom-button btn btn-success btn-icon-split" name="upload">Guardar</button>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<script>
  document.getElementById('toggle-menu')?.addEventListener('click', function (e) {
    e.preventDefault();
    document.getElementById('page-container').classList.toggle('sidebar-collapsed');
  });
</script>
<?php include "includes/footer.php"; ?>
</body>
</html>
