<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

include(__DIR__ . '/includes/header.php');

$success_message = "";
$error_message = "";

$jsonPath = __DIR__ . '/api/custom_qr.json';

if (!is_dir(__DIR__ . '/api')) {
    mkdir(__DIR__ . '/api', 0755, true);
}

// Si el archivo no existe, lo crea con una estructura vacía
if (!file_exists($jsonPath)) {
    file_put_contents($jsonPath, json_encode(['url' => ''], JSON_PRETTY_PRINT));
}

$data = json_decode(file_get_contents($jsonPath), true);
$current_url = $data['url'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['qr_url'])) {
    $url = trim($_POST['qr_url']);

    if (filter_var($url, FILTER_VALIDATE_URL)) {
        file_put_contents($jsonPath, json_encode(['url' => $url], JSON_PRETTY_PRINT));
        $success_message = "URL guardada con éxito.";
        $current_url = $url;
    } else {
        $error_message = "La URL ingresada no es válida.";
    }
}
?>
<div class="col-md-8 mx-auto">
            <div class="card-body">
                <div class="card bg-dark text-white">
                    <div class="card-header card-header-warning">
                        <center>
            <h2 class="mb-9">Link para el botón de Sitio Web</h2>

            <?php if (!empty($success_message)): ?>
                <div class="alert alert-success" role="alert" id="alert-success">
                    <?= htmlspecialchars($success_message) ?>
                </div>
            <?php elseif (!empty($error_message)): ?>
                <div class="alert alert-danger" role="alert">
                    <?= htmlspecialchars($error_message) ?>
                </div>
            <?php endif; ?>

            <form method="POST" action="">
                <div class="form-group">
                    <label for="qr_url">URL personalizada:</label>
                    <input 
                        type="url" 
                        class="form-control" 
                        name="qr_url" 
                        id="qr_url" 
                        placeholder="https://midominio.com/activar.php" 
                        value="<?= htmlspecialchars($current_url) ?>" 
                        required>
                </div>
                <div class="text-center mt-4">
                    <button type="submit" class="btn btn-primary">Guardar URL</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
// Ocultar mensaje de éxito después de 3 segundos
setTimeout(() => {
    const alert = document.getElementById('alert-success');
    if (alert) {
        alert.style.display = 'none';
    }
}, 3000);
</script>

<?php include 'includes/footer.php'; ?>
