<?php
include_once 'functions.php';

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['username'])) {
    // Redirect to index.php if not logged in
    header('Location: index.php');
    exit;
}

http_response_code(403); // Set HTTP status code to 403
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="403 Forbidden">
    <meta name="keywords" content="403, forbidden, access denied">
    <meta name="author" content="litePanel">
    <title>403 Forbidden - litePanel</title>

    <!-- Styles -->
    <link href="https://fonts.googleapis.com/css?family=Poppins:400,500,700,800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <link rel="icon" type="image/png" sizes="32x32" href="../assets/favicon-32x32.png">
    <link href="../assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="../assets/plugins/font-awesome/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/main.min.css" rel="stylesheet">
    <link href="../assets/css/custom.css" rel="stylesheet">
</head>
<style>
    body {
        background-color: #121212; /* Dark background */
        font-family: 'Poppins', sans-serif;
        display: flex;
        align-items: center;
        justify-content: center;
        height: 100vh;
        margin: 0;
        color: #f0f0f0; /* Light text color */
    }
    .error-container {
        max-width: 700px;
        background-color: #1c1c1c; /* Dark container */
        border-radius: 10px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.4);
        padding: 40px;
        text-align: center;
    }
    .error-container img {
        width: 100px;
        margin-bottom: 20px;
    }
    .error-code {
        font-size: 6rem;
        font-weight: 700;
        color: #ff5252;
        margin: 0;
    }
    .error-message {
        font-size: 1.75rem;
        font-weight: 500;
        margin-bottom: 1rem;
        color: #83d8ae;
    }
    .error-details {
        font-size: 1rem;
        color: #b0b0b0;
        margin-bottom: 2rem;
    }
    .error-btn {
        padding: 10px 30px;
        background-color: #83d8ae;
        color: #121212;
        border-radius: 50px;
        text-transform: uppercase;
        font-weight: 500;
        text-decoration: none;
        transition: background-color 0.3s;
    }
    .error-btn:hover {
        background-color: #6cb993;
    }
</style>
<body>
    <div class="error-container">
        <img src="../assets/android-chrome-512x512.png" alt="Error Image">
        <h1 class="error-code">403</h1>
        <p class="error-message">Access Denied</p>
        <p class="error-details">You do not have permission to view this page. Please contact the administrator for more information.</p>
        <a href="index.php" class="error-btn">Back to Home</a>
    </div>
</body>
</html>
