<?php
ob_start();
include_once 'includes/functions.php';

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['username'])) {
    header('Location: index.php');
    exit;
}

// Initialize variables
$dns_code = '';
$dns_name = '';
$dns_url = '';
$dns_message = '';
$dns_background = '';
$dns_logo = '';
$dns_intro = '';
$edit_mode = false;

// Check if 'id' parameter is provided for editing
if (isset($_GET['id'])) {
    $dns_id = $_GET['id'];
    // Fetch the record from the database
    $dns_record = $db->select('dns', '*', ['id' => $dns_id]);

    if ($dns_record) {
        // Populate form fields with the existing data
        $dns_code = $dns_record[0]['dns_code'];
        $dns_name = $dns_record[0]['dns_name'];
        $dns_url = $dns_record[0]['dns_url'];
        $dns_message = $dns_record[0]['dns_message'];
        $dns_background = $dns_record[0]['dns_background'];
        $dns_logo = $dns_record[0]['dns_logo'];
        $dns_intro = $dns_record[0]['dns_intro'];
        $edit_mode = true;
    }
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['dnssubmit'])) {
    $dns_code = $_POST['dns_code'];
    $dns_name = $_POST['dns_name'];
    $dns_url = $_POST['dns_url'];
    $dns_message = $_POST['dns_message'];
    $dns_background = $_POST['dns_background'];
    $dns_logo = $_POST['dns_logo'];
    $dns_intro = $_POST['dns_intro'];

    if ($edit_mode) {
        // Update the existing DNS record
        $db->update('dns', [
            'dns_code' => $dns_code,
            'dns_name' => $dns_name,
            'dns_url' => $dns_url,
            'dns_message' => $dns_message,
            'dns_background' => $dns_background,
            'dns_logo' => $dns_logo,
            'dns_intro' => $dns_intro,
        ], ['id' => $dns_id]);
        $success_message = "DNS record updated successfully!";
    } else {
        // Insert a new DNS record
        $db->insert('dns', [
            'dns_code' => $dns_code,
            'dns_name' => $dns_name,
            'dns_url' => $dns_url,
            'dns_message' => $dns_message,
            'dns_background' => $dns_background,
            'dns_logo' => $dns_logo,
            'dns_intro' => $dns_intro,
        ]);
        $success_message = "DNS record added successfully!";
    }
    // Redirect back to the main DNS page after saving
    header('Location: dashboard.php?dns');
    exit;
}

// HTML structure using only echo statements
echo '<h5 class="card-title">' . ($edit_mode ? 'Edit DNS' : 'Add New DNS') . '</h5>';
echo '<form action="" method="POST">';

// Code field
echo '<div class="mb-3">';
echo '<label for="dns_code" class="form-label">Code</label>';
echo '<input type="text" class="form-control" name="dns_code" value="' . htmlspecialchars($dns_code) . '" required>';
echo '</div>';

// Name field
echo '<div class="mb-3">';
echo '<label for="dns_name" class="form-label">Name</label>';
echo '<input type="text" class="form-control" name="dns_name" value="' . htmlspecialchars($dns_name) . '" required>';
echo '</div>';

// URL field
echo '<div class="mb-3">';
echo '<label for="dns_url" class="form-label">URL</label>';
echo '<input type="text" class="form-control" name="dns_url" value="' . htmlspecialchars($dns_url) . '" required>';
echo '</div>';

// Message field
echo '<div class="mb-3">';
echo '<label for="dns_message" class="form-label">Message</label>';
echo '<input type="text" class="form-control" name="dns_message" value="' . htmlspecialchars($dns_message) . '">';
echo '</div>';

// Background Image field
echo '<div class="mb-3">';
echo '<label for="dns_background" class="form-label">Background Image URL</label>';
echo '<input type="text" class="form-control" name="dns_background" value="' . htmlspecialchars($dns_background) . '">';
echo '</div>';

// Logo field
echo '<div class="mb-3">';
echo '<label for="dns_logo" class="form-label">Logo Image URL</label>';
echo '<input type="text" class="form-control" name="dns_logo" value="' . htmlspecialchars($dns_logo) . '">';
echo '</div>';

// Intro Video URL field
echo '<div class="mb-3">';
echo '<label for="dns_intro" class="form-label">Intro Video URL</label>';
echo '<input type="text" class="form-control" name="dns_intro" value="' . htmlspecialchars($dns_intro) . '">';
echo '<small class="form-text text-muted">The intro video must be in MP4 format (e.g., https://example.com/video.mp4).</small>';
echo '</div>';

// Submit button
echo '<button name="dnssubmit" type="submit" class="btn btn-primary">' . ($edit_mode ? 'Update DNS' : 'Save DNS') . '</button>';
echo '</form>';
ob_end_flush();