<?php
ob_start(); // Start output buffering
include_once 'includes/functions.php';

// Handle DNS deletion
if ($section === 'dns' && isset($_GET['delete'])) {
    $dns_id = (int) $_GET['delete'];
    $db->delete('dns', ['id' => $dns_id]);
    header('Location: dashboard.php?dns');
    exit;
}

$dns_records = $db->select('dns');
ob_end_flush(); // Flush output after logic
?>

<?php
// Main wrapper start
echo '<div class="main-wrapper" style="padding: 0; margin-top: 0;">';
echo '<div class="row">';
echo '<div class="col-12">';
echo '<div class="card" style="margin: 0; border: none;">';
echo '<div class="card-body" style="padding: 10px 15px;">';

// Header with Add New button
echo '<div class="d-flex justify-content-between align-items-center mb-3">';
echo '<h5 class="card-title" style="font-size: 1.2rem; margin-bottom: 0; color: #9a9cab;">DNS</h5>';
echo '<a href="dashboard.php?dns-manage">';
echo '<button type="button" class="btn btn-success">Add New</button>';
echo '</a>';
echo '</div>';

// Table structure
echo '<table class="table" style="color: #9a9cab; border-collapse: collapse;">';
echo '<thead>';
echo '<tr>';
echo '<th scope="col" style="width: 5%; padding: 10px; border-color: #262635;">#</th>';
echo '<th scope="col" style="padding: 10px; border-color: #262635;">Code</th>';
echo '<th scope="col" style="padding: 10px; border-color: #262635;">Name</th>';
echo '<th scope="col" style="padding: 10px; border-color: #262635;">DNS</th>';
echo '<th scope="col" style="width: 25%; padding: 10px; border-color: #262635;">Actions</th>';
echo '</tr>';
echo '</thead>';
echo '<tbody>';

// DNS records
if (!empty($dns_records)) {
    foreach ($dns_records as $index => $record) {
        echo '<tr style="border-bottom: 1px solid #262635;">';
        echo '<th scope="row" style="padding: 15px 20px; vertical-align: middle;">' . ($index + 1) . '</th>';
        echo '<td style="padding: 15px 20px; vertical-align: middle;">' . htmlspecialchars($record['dns_code']) . '</td>';
        echo '<td style="padding: 15px 20px; vertical-align: middle;">' . htmlspecialchars($record['dns_name']) . '</td>';
        echo '<td style="padding: 15px 20px; vertical-align: middle;">' . htmlspecialchars($record['dns_url']) . '</td>';
        echo '<td style="padding: 15px 20px; vertical-align: middle;">';
        echo '<a href="dashboard.php?dns-manage&id=' . $record['id'] . '">';
        echo '<button type="button" class="btn btn-warning btn-md">Manage</button>';
        echo '</a>';
        echo '<button type="button" class="btn btn-danger btn-md" data-bs-toggle="modal" data-bs-target="#deleteModal" onclick="setDeleteId(' . $record['id'] . ')">Delete</button>';
        echo '</td>';
        echo '</tr>';
    }
} else {
    // No DNS records
    echo '<tr>';
    echo '<td colspan="5" class="text-center" style="padding: 15px 20px; border-color: #262635;">Please add a DNS.</td>';
    echo '</tr>';
}

echo '</tbody>';
echo '</table>';
echo '</div>'; // End card body
echo '</div>'; // End card
echo '</div>'; // End col
echo '</div>'; // End row
echo '</div>'; // End main wrapper

// Delete Modal
echo '<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">';
echo '<div class="modal-dialog modal-dialog-centered">';
echo '<div class="modal-content" style="background-color: #262635; color: #fff;">';
echo '<div class="modal-header">';
echo '<h5 class="modal-title" id="deleteModalLabel" style="color: #f5f5f5;">Confirm Delete</h5>';
echo '</div>';
echo '<div class="modal-body" style="color: #e0e0e0;">';
echo 'Are you sure you want to delete this DNS record? This action cannot be undone.';
echo '</div>';
echo '<div class="modal-footer">';
echo '<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>';
echo '<button type="button" class="btn btn-danger" id="confirmDeleteButton">Delete</button>';
echo '</div>';
echo '</div>';
echo '</div>';
echo '</div>';

// Script for modal delete functionality
echo '<script>';
echo 'function setDeleteId(dnsId) {';
echo 'document.getElementById("confirmDeleteButton").setAttribute("onclick", "confirmDelete(" + dnsId + ")");';
echo '}';
echo 'function confirmDelete(dnsId) {';
echo 'window.location.href = "dashboard.php?dns&delete=" + dnsId;';
echo '}';
echo '</script>';
?>
