<?php
ob_start(); // Start output buffering
include_once 'includes/functions.php';

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['username'])) {
    header('Location: index.php');
    exit;
}

if (isset($_GET['logout'])) {
    // Clear the session
    $_SESSION = [];
    
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000, $params["path"], $params["domain"], $params["secure"], $params["httponly"]);
    }
    session_destroy();
    header('Location: index.php');
    exit;
}

// Set the section based on the GET parameters
$section = 'dns'; // Default section

if (isset($_GET['dns-manage'])) {
    $section = 'dns-manage';
} elseif (isset($_GET['account'])) {
    $section = 'account';
}

// Handle DNS deletion
if ($section === 'dns' && isset($_GET['delete'])) {
    $dns_id = (int) $_GET['delete'];
    $db->delete('dns', ['id' => $dns_id]);
    header('Location: dashboard.php?dns');
    exit;
}

// Start generating the dashboard page with PHP echo statements
echo '<!DOCTYPE html>';
echo '<html lang="en">';
echo '<head>';
echo '<meta charset="utf-8">';
echo '<meta http-equiv="X-UA-Compatible" content="IE=edge">';
echo '<meta name="viewport" content="width=device-width, initial-scale=1">';
echo '<meta name="description" content="Responsive Admin Dashboard Template">';
echo '<meta name="keywords" content="admin,dashboard">';
echo '<meta name="author" content="stacks">';
echo '<title>litePanel</title>';
echo '<link href="https://fonts.googleapis.com/css?family=Poppins:400,500,700,800&amp;display=swap" rel="stylesheet">';
echo '<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">';
echo '<link rel="icon" type="image/png" sizes="32x32" href="assets/favicon-32x32.png">';
echo '<link rel="icon" type="image/png" sizes="16x16" href="assets/favicon-16x16.png">';
echo '<link rel="manifest" href="assets/site.webmanifest">';
echo '<link href="assets/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet">';
echo '<link href="assets/plugins/font-awesome/css/all.min.css" rel="stylesheet">';
echo '<link href="assets/plugins/perfectscroll/perfect-scrollbar.css" rel="stylesheet">';
echo '<link href="assets/plugins/pace/pace.css" rel="stylesheet">';
echo '<link href="assets/css/main.min.css" rel="stylesheet">';
echo '<link href="assets/css/custom.css" rel="stylesheet">';
echo '</head>';
echo '<body class="pace-done no-loader">';
echo '<div class="page-container">';

// Sidebar
echo '<div class="page-sidebar ps ps--active-y">';
echo '<a style="display:block;text-align: center;width:100% !important;" href="dashboard.php">';
echo '<img style="width:80px;padding:10px;" src="assets/android-chrome-512x512.png">';
echo '</a>';
echo '<a class="logo" style="font-size:14px;margin-top:0;" href="dashboard.php">Legazy</a>';
echo '<ul class="list-unstyled accordion-menu ps">';

// DNS Section
echo '<li class="' . ($section === 'dns' ? 'active-page' : '') . '">';
echo '<a href="dashboard.php?dns">';
echo '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-server">';
echo '<rect x="2" y="2" width="20" height="8" rx="2" ry="2"></rect>';
echo '<rect x="2" y="14" width="20" height="8" rx="2" ry="2"></rect>';
echo '<line x1="6" y1="6" x2="6.01" y2="6"></line>';
echo '<line x1="6" y1="18" x2="6.01" y2="18"></line>';
echo '</svg>DNS</a></li>';

// Account Section
echo '<li class="' . ($section === 'account' ? 'active-page' : '') . '">';
echo '<a href="dashboard.php?account">';
echo '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user">';
echo '<path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path>';
echo '<circle cx="12" cy="7" r="4"></circle>';
echo '</svg>Account</a></li>';

// Logout Section
echo '<li><a href="dashboard.php?logout">';
echo '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-log-out">';
echo '<path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"></path>';
echo '<polyline points="16 17 21 12 16 7"></polyline>';
echo '<line x1="21" y1="12" x2="9" y2="12"></line>';
echo '</svg>Log Out</a></li>';
echo '</ul>';
echo '<a href="#" id="sidebar-collapsed-toggle">';
echo '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-right">';
echo '<line x1="5" y1="12" x2="19" y2="12"></line>';
echo '<polyline points="12 5 19 12 12 19"></polyline>';
echo '</svg></a></div>';

// Page Content
echo '<div class="page-content">';
echo '<div class="page-header">';
echo '<nav class="navbar navbar-expand-lg d-flex justify-content-between">';
echo '<div class="header-title flex-fill">';
echo '<a href="#" id="sidebar-toggle">';
echo '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-left">';
echo '<line x1="19" y1="12" x2="5" y2="12"></line>';
echo '<polyline points="12 19 5 12 12 5"></polyline>';
echo '</svg></a>';
echo '<h5>Dashboard</h5>';
echo '</div>';
echo '</nav>';
echo '</div>';

// Main Content Wrapper
echo '<div class="main-wrapper">';
echo '<div class="row">';
echo '<div class="col">';
echo '<div class="card">';
echo '<div class="card-body">';

// Include the relevant section based on the value of $section
if ($section === 'dns') {
    include 'dns.php'; 
} elseif ($section === 'dns-manage') {
    include 'dns_management.php'; 
} elseif ($section === 'account') {
    include 'account.php';
} else {
    include 'dns.php'; 
}

echo '</div>'; // Close card-body
echo '</div>'; // Close card
echo '</div>'; // Close col
echo '</div>'; // Close row
echo '</div>'; // Close main-wrapper

// Page Footer
echo '<div class="page-footer">';
echo '<div class="page-footer-item page-footer-item-right">';
echo '<a style="color: #83d8ae; font-weight: 500;" href="https://t.me/">';
echo '<img style="width:30px" src="assets/images/telegram.png">&nbsp;&nbsp;Telegram';
echo '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-arrow-right footer-right">';
echo '<line x1="5" y1="12" x2="19" y2="12"></line>';
echo '<polyline points="12 5 19 12 12 19"></polyline>';
echo '</svg></a>';
echo '</div>';
echo '</div>'; // Close page-footer

echo '</div>'; // Close page-content
echo '</div>'; // Close page-container

// Scripts
echo '<script src="assets/plugins/jquery/jquery-3.4.1.min.js"></script>';
echo '<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/2.11.6/umd/popper.min.js"></script>';
echo '<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>';
echo '<script src="assets/js/feather.js"></script>';
echo '<script src="assets/plugins/perfectscroll/perfect-scrollbar.min.js"></script>';
echo '<script src="assets/plugins/pace/pace.min.js"></script>';
echo '<script src="assets/js/main.min.js"></script>';
echo '</body>';
echo '</html>';

ob_end_flush(); // End output buffering and send output
?>
