<?php
include_once '../includes/functions.php';
header('Content-Type: application/json');

if (!isset($_GET['usera']) || !isset($_GET['type'])) {
    echo json_encode([
        'token' => 'Cuenta Invalida',
        'servidor' => 'No URL',
        'message' => '',
        'package' => '',
        'background' => '',
        'logo' => ''
    ]);
    exit;
}

$usera = htmlspecialchars(strip_tags($_GET['usera']));
$type = htmlspecialchars(strip_tags($_GET['type']));

$dns_record = $db->select('dns', '*', ['dns_code' => $usera], false);

if ($dns_record) {
    $dns_url = rtrim($dns_record['dns_url'], '/') . '/';

    echo json_encode([
        'token' => 'OK',
        'servers' => $dns_url,  
        'message' => $dns_record['dns_message'],
        'package' => '1',
        'background' => $dns_record['dns_background'],
        'logo' => $dns_record['dns_logo'],
        'intro' => $dns_record['dns_intro'],
        'help' => "#",
        'estatus' => "1",
        'agent' => "Legazy_IPTV_Player_2"
    ]);
} else {
    echo json_encode([
        'token' => 'Cuenta Invalida',
        'servidor' => 'No URL',
        'message' => '',
        'package' => '',
        'background' => '',
        'logo' => ''
    ]);
}
?>
